/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import java.util.EmptyStackException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.cdr.extension.ExtensionContext;
import org.milyn.cdr.extension.MapToResourceConfigFromText;
import org.milyn.cdr.extension.ResourceConfigUtil;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.w3c.dom.Element;

public class SetOnResourceConfig
implements DOMVisitBefore {
    private static Log logger = LogFactory.getLog(MapToResourceConfigFromText.class);
    @ConfigParam
    private String setOn;
    @ConfigParam
    private String value;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        SmooksResourceConfiguration config;
        try {
            config = ExtensionContext.getExtensionContext(executionContext).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No SmooksResourceConfiguration available in ExtensionContext stack.  Unable to set SmooksResourceConfiguration property '" + this.setOn + "' with static value.");
        }
        logger.debug((Object)("Setting property '" + this.setOn + "' on resource configuration to a value of '" + this.value + "'."));
        ResourceConfigUtil.setProperty(config, this.setOn, this.value, executionContext);
    }
}

