/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mockserver.collections.Keyed;

public class CircularPriorityQueue<K, V, SLK extends Keyed<K>> {
    private int maxSize;
    private final Function<V, SLK> skipListKeyFunction;
    private final Function<V, K> mapKeyFunction;
    private final ConcurrentSkipListSet<SLK> sortOrderSkipList;
    private final ConcurrentLinkedQueue<V> insertionOrderQueue = new ConcurrentLinkedQueue();
    private final ConcurrentMap<K, V> byKey = new ConcurrentHashMap();

    public CircularPriorityQueue(int maxSize, Comparator<? super SLK> skipListComparator, Function<V, SLK> skipListKeyFunction, Function<V, K> mapKeyFunction) {
        this.sortOrderSkipList = new ConcurrentSkipListSet<SLK>(skipListComparator);
        this.maxSize = maxSize;
        this.skipListKeyFunction = skipListKeyFunction;
        this.mapKeyFunction = mapKeyFunction;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void removePriorityKey(V element) {
        this.sortOrderSkipList.remove(this.skipListKeyFunction.apply(element));
    }

    public void addPriorityKey(V element) {
        this.sortOrderSkipList.add(this.skipListKeyFunction.apply(element));
    }

    public void add(V element) {
        if (this.maxSize > 0 && element != null) {
            this.insertionOrderQueue.offer(element);
            this.sortOrderSkipList.add(this.skipListKeyFunction.apply(element));
            this.byKey.put(this.mapKeyFunction.apply(element), element);
            while (this.insertionOrderQueue.size() > this.maxSize) {
                V elementToRemove = this.insertionOrderQueue.poll();
                this.sortOrderSkipList.remove(this.skipListKeyFunction.apply(elementToRemove));
                this.byKey.remove(this.mapKeyFunction.apply(elementToRemove));
            }
        }
    }

    public boolean remove(V element) {
        if (element != null) {
            this.insertionOrderQueue.remove(element);
            this.byKey.remove(this.mapKeyFunction.apply(element));
            return this.sortOrderSkipList.remove(this.skipListKeyFunction.apply(element));
        }
        return false;
    }

    public int size() {
        return this.insertionOrderQueue.size();
    }

    public Stream<V> stream() {
        return this.sortOrderSkipList.stream().map(item -> this.byKey.get(item.getKey())).filter(Objects::nonNull);
    }

    public Optional<V> getByKey(K key) {
        if (key != null && !"".equals(key)) {
            return Optional.ofNullable(this.byKey.get(key));
        }
        return Optional.empty();
    }

    public Map<K, V> keyMap() {
        return new HashMap<K, V>(this.byKey);
    }

    public boolean isEmpty() {
        return this.insertionOrderQueue.isEmpty();
    }

    public List<V> toSortedList() {
        return this.stream().collect(Collectors.toList());
    }
}

