/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import java.util.List;
import org.mockserver.model.Body;
import org.mockserver.model.Cookies;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameters;
import org.mockserver.model.Protocol;
import org.mockserver.model.SocketAddress;
import org.mockserver.model.X509Certificate;
import org.mockserver.serialization.model.BodyDTO;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.RequestDefinitionDTO;

public class HttpRequestDTO
extends RequestDefinitionDTO
implements DTO<HttpRequest> {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private Parameters pathParameters;
    private Parameters queryStringParameters;
    private BodyDTO body;
    private Cookies cookies;
    private Headers headers;
    private Boolean keepAlive;
    private Boolean secure;
    private Protocol protocol;
    private List<X509Certificate> clientCertificateChain;
    private SocketAddress socketAddress;
    private String localAddress;
    private String remoteAddress;

    public HttpRequestDTO() {
        super(null);
    }

    public HttpRequestDTO(HttpRequest httpRequest) {
        super(httpRequest != null ? httpRequest.getNot() : null);
        if (httpRequest != null) {
            this.method = httpRequest.getMethod();
            this.path = httpRequest.getPath();
            this.headers = httpRequest.getHeaders();
            this.cookies = httpRequest.getCookies();
            this.pathParameters = httpRequest.getPathParameters();
            this.queryStringParameters = httpRequest.getQueryStringParameters();
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.secure = httpRequest.isSecure();
            this.protocol = httpRequest.getProtocol();
            this.clientCertificateChain = httpRequest.getClientCertificateChain();
            this.socketAddress = httpRequest.getSocketAddress();
            this.localAddress = httpRequest.getLocalAddress();
            this.remoteAddress = httpRequest.getRemoteAddress();
        }
    }

    @Override
    public HttpRequest buildObject() {
        return (HttpRequest)new HttpRequest().withMethod(this.method).withPath(this.path).withPathParameters(this.pathParameters).withQueryStringParameters(this.queryStringParameters).withBody(this.body != null ? (Body)Not.not(this.body.buildObject(), this.body.getNot()) : null).withHeaders(this.headers).withCookies(this.cookies).withSecure(this.secure).withProtocol(this.protocol).withKeepAlive(this.keepAlive).withClientCertificateChain(this.clientCertificateChain).withSocketAddress(this.socketAddress).withLocalAddress(this.localAddress).withRemoteAddress(this.remoteAddress).withNot(this.getNot());
    }

    public NottableString getMethod() {
        return this.method;
    }

    public HttpRequestDTO setMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public HttpRequestDTO setPath(NottableString path) {
        this.path = path;
        return this;
    }

    public Parameters getPathParameters() {
        return this.pathParameters;
    }

    public HttpRequestDTO setPathParameters(Parameters pathParameters) {
        this.pathParameters = pathParameters;
        return this;
    }

    public Parameters getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestDTO setQueryStringParameters(Parameters queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public HttpRequestDTO setBody(BodyDTO body) {
        this.body = body;
        return this;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public HttpRequestDTO setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Cookies getCookies() {
        return this.cookies;
    }

    public HttpRequestDTO setCookies(Cookies cookies) {
        this.cookies = cookies;
        return this;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequestDTO setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public HttpRequestDTO setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public HttpRequestDTO setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<X509Certificate> getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    public HttpRequestDTO setClientCertificateChain(List<X509Certificate> clientCertificateChain) {
        this.clientCertificateChain = clientCertificateChain;
        return this;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public HttpRequestDTO setSocketAddress(SocketAddress socketAddress) {
        this.socketAddress = socketAddress;
        return this;
    }

    public String getLocalAddress() {
        return this.localAddress;
    }

    public HttpRequestDTO setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
        return this;
    }

    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public HttpRequestDTO setRemoteAddress(String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }
}

