/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.mustache;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.configuration.Configuration;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.DTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.TemplateFunctions;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.mustache.ExtendedCollector;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.mockserver.xml.XPathEvaluator;
import org.slf4j.event.Level;

public class MustacheTemplateEngine
implements TemplateEngine {
    private static ObjectMapper objectMapper;
    private final MockServerLogger mockServerLogger;
    private final Configuration configuration;
    private final Mustache.Compiler compiler;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public MustacheTemplateEngine(MockServerLogger mockServerLogger, Configuration configuration) {
        this.mockServerLogger = mockServerLogger;
        this.configuration = configuration;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(mockServerLogger);
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.createObjectMapper();
        }
        this.compiler = Mustache.compiler().emptyStringIsFalse(true).zeroIsFalse(true).strictSections(false).defaultValue("").withCollector((Mustache.Collector)new ExtendedCollector());
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        Object result;
        try {
            JsonNode generatedObject;
            StringWriter writer;
            block5: {
                this.validateTemplate(template);
                writer = new StringWriter();
                Template compiledTemplate = this.compiler.compile(template);
                ConcurrentHashMap<String, Object> data = new ConcurrentHashMap<String, Object>();
                data.put("request", new HttpRequestTemplateObject(request));
                data.putAll(TemplateFunctions.BUILT_IN_FUNCTIONS);
                data.put("xPath", (frag, out) -> this.evaluatedXPath(frag.execute(), request, out));
                data.put("jsonPath", (frag, out) -> this.evaluateJsonPath(data, frag.execute(), request, out));
                compiledTemplate.execute(data, (Writer)writer);
                generatedObject = null;
                try {
                    generatedObject = objectMapper.readTree(((Object)writer).toString());
                }
                catch (Throwable throwable) {
                    if (!MockServerLogger.isEnabled(Level.INFO)) break block5;
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception deserialising generated content:{}into json node for request:{}").setArguments(((Object)writer).toString(), request));
                }
            }
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TEMPLATE_GENERATED).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("generated output:{}from template:{}for request:{}").setArguments(generatedObject != null ? generatedObject : ((Object)writer).toString(), template, request));
            }
            result = this.httpTemplateOutputDeserializer.deserializer(request, ((Object)writer).toString(), dtoClass);
        }
        catch (Exception e) {
            throw new RuntimeException(StringFormatter.formatLogMessage("Exception:{}transforming template:{}for request:{}", StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName(), template, request), e);
        }
        return result;
    }

    private void validateTemplate(String template) {
        if (StringUtils.isNotBlank((CharSequence)template) && StringUtils.isNotBlank((CharSequence)this.configuration.mustacheDisallowedText())) {
            Iterable deniedStrings = Splitter.on((String)",").trimResults().split((CharSequence)this.configuration.mustacheDisallowedText());
            for (String deniedString : deniedStrings) {
                if (!template.contains(deniedString)) continue;
                throw new UnsupportedOperationException("Found disallowed string \"" + deniedString + "\" in template: " + template);
            }
        }
    }

    private void evaluateJsonPath(Map<String, Object> data, String jsonPath, HttpRequest request, Writer out) {
        try {
            Object jsonPathResult = JsonPath.compile((String)jsonPath, (Predicate[])new Predicate[0]).read(request.getBodyAsJsonOrXmlString());
            data.put("jsonPathResult", jsonPathResult);
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("evaluated jsonPath:{}against json body:{}as:{}").setArguments(jsonPath, request.getBodyAsJsonOrXmlString(), jsonPathResult));
            }
            out.write("");
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception evaluating jsonPath:{}against json body:{}").setArguments(jsonPath, request.getBodyAsJsonOrXmlString()).setThrowable(throwable));
        }
    }

    private void evaluatedXPath(String xPath, HttpRequest request, Writer out) {
        try {
            String xPathResult = String.valueOf(new XPathEvaluator(xPath, null).evaluateXPathExpression(request.getBodyAsJsonOrXmlString(), (matched, exception, level) -> this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception evaluating xPath:{}against xml body:{}").setArguments(xPath, request.getBodyAsJsonOrXmlString()).setThrowable(exception)), XPathConstants.STRING));
            if (MockServerLogger.isEnabled(Level.TRACE)) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setHttpRequest(request).setMessageFormat("evaluated xPath:{}against xml body:{}as:{}").setArguments(xPath, request.getBodyAsJsonOrXmlString(), xPathResult));
            }
            out.write(xPathResult);
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception evaluating xPath:{}against xml body:{}").setArguments(xPath, request.getBodyAsJsonOrXmlString()).setThrowable(throwable));
        }
    }
}

