/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.List;
import java.util.Set;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.Cookies;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Parameter;
import org.mockserver.model.Parameters;
import org.mockserver.url.URLParser;

public class MockServerRequestDecoder
extends MessageToMessageDecoder<FullHttpRequest> {
    private final MockServerLogger mockServerLogger;
    private final boolean isSecure;

    public MockServerRequestDecoder(MockServerLogger mockServerLogger, boolean isSecure) {
        this.mockServerLogger = mockServerLogger;
        this.isSecure = isSecure;
    }

    protected void decode(ChannelHandlerContext ctx, FullHttpRequest fullHttpRequest, List<Object> out) {
        out.add(this.decode(fullHttpRequest));
    }

    public HttpRequest decode(FullHttpRequest fullHttpRequest) {
        HttpRequest httpRequest = new HttpRequest();
        if (fullHttpRequest != null) {
            this.setMethod(httpRequest, fullHttpRequest);
            this.setPath(httpRequest, fullHttpRequest);
            this.setQueryString(httpRequest, new QueryStringDecoder(fullHttpRequest.uri()));
            this.setHeaders(httpRequest, fullHttpRequest);
            this.setCookies(httpRequest, fullHttpRequest);
            this.setBody(httpRequest, fullHttpRequest);
            httpRequest.withKeepAlive(HttpUtil.isKeepAlive((HttpMessage)fullHttpRequest));
            httpRequest.withSecure(this.isSecure);
        }
        return httpRequest;
    }

    private void setMethod(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        httpRequest.withMethod(fullHttpResponse.method().name());
    }

    private void setPath(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withPath(URLParser.returnPath(fullHttpRequest.uri()));
    }

    private void setQueryString(HttpRequest httpRequest, QueryStringDecoder queryStringDecoder) {
        Parameters parameters = new Parameters(new Parameter[0]);
        try {
            parameters.withEntries(queryStringDecoder.parameters());
        }
        catch (IllegalArgumentException iae) {
            this.mockServerLogger.error(httpRequest, "Exception while parsing query string", iae);
        }
        httpRequest.withQueryStringParameters(parameters);
    }

    private void setHeaders(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        Headers headers = new Headers(new Header[0]);
        HttpHeaders httpHeaders = fullHttpResponse.headers();
        for (String headerName : httpHeaders.names()) {
            headers.withEntry(new Header(headerName, httpHeaders.getAll(headerName)));
        }
        httpRequest.withHeaders(headers);
    }

    private void setCookies(HttpRequest httpRequest, FullHttpRequest fullHttpResponse) {
        Cookies cookies = new Cookies(new org.mockserver.model.Cookie[0]);
        for (String cookieHeader : fullHttpResponse.headers().getAll((CharSequence)HttpHeaderNames.COOKIE)) {
            Set decodedCookies = ServerCookieDecoder.LAX.decode(cookieHeader);
            for (Cookie decodedCookie : decodedCookies) {
                cookies.withEntry(new org.mockserver.model.Cookie(decodedCookie.name(), decodedCookie.value()));
            }
        }
        httpRequest.withCookies(cookies);
    }

    private void setBody(HttpRequest httpRequest, FullHttpRequest fullHttpRequest) {
        httpRequest.withBody(BodyDecoderEncoder.byteBufToBody(fullHttpRequest.content(), fullHttpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)));
    }
}

