/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.codec.BodyDecoderEncoder;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;
import org.mockserver.model.BodyWithContentType;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;

public class MockServerResponseEncoder
extends MessageToMessageEncoder<HttpResponse> {
    protected void encode(ChannelHandlerContext ctx, HttpResponse response, List<Object> out) {
        out.add(this.encode(response));
    }

    public DefaultFullHttpResponse encode(HttpResponse httpResponse) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.getStatus(httpResponse), this.getBody(httpResponse));
        this.setHeaders(httpResponse, defaultFullHttpResponse);
        this.setCookies(httpResponse, defaultFullHttpResponse);
        return defaultFullHttpResponse;
    }

    private HttpResponseStatus getStatus(HttpResponse httpResponse) {
        int statusCode;
        int n = statusCode = httpResponse.getStatusCode() != null ? httpResponse.getStatusCode() : 200;
        if (!StringUtils.isEmpty((CharSequence)httpResponse.getReasonPhrase())) {
            return new HttpResponseStatus(statusCode, httpResponse.getReasonPhrase());
        }
        return HttpResponseStatus.valueOf((int)statusCode);
    }

    private ByteBuf getBody(HttpResponse httpResponse) {
        return BodyDecoderEncoder.bodyToByteBuf(httpResponse.getBody(), httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString()));
    }

    private void setHeaders(HttpResponse httpResponse, DefaultFullHttpResponse response) {
        if (httpResponse.getHeaderList() != null) {
            for (Header header : httpResponse.getHeaderList()) {
                for (NottableString value : header.getValues()) {
                    response.headers().add(header.getName().getValue(), (Object)value.getValue());
                }
            }
        }
        if (Strings.isNullOrEmpty((String)httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString())) && httpResponse.getBody() != null && httpResponse.getBody().getContentType() != null) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)httpResponse.getBody().getContentType());
        }
        if (Strings.isNullOrEmpty((String)httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString()))) {
            boolean addContentLength;
            ConnectionOptions connectionOptions = httpResponse.getConnectionOptions();
            boolean overrideContentLength = connectionOptions != null && connectionOptions.getContentLengthHeaderOverride() != null;
            boolean bl = addContentLength = connectionOptions == null || ConnectionOptions.isFalseOrNull(connectionOptions.getSuppressContentLengthHeader());
            if (overrideContentLength) {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)connectionOptions.getContentLengthHeaderOverride());
            } else if (addContentLength) {
                BodyWithContentType body = httpResponse.getBody();
                byte[] bodyBytes = new byte[]{};
                if (body != null) {
                    Object bodyContents = body.getValue();
                    Charset bodyCharset = ((Body)body).getCharset(ContentTypeMapper.getCharsetFromContentTypeHeader(httpResponse.getFirstHeader(HttpHeaderNames.CONTENT_TYPE.toString())));
                    if (bodyContents instanceof byte[]) {
                        bodyBytes = (byte[])bodyContents;
                    } else if (bodyContents instanceof String) {
                        bodyBytes = ((String)bodyContents).getBytes(bodyCharset);
                    } else if (body.toString() != null) {
                        bodyBytes = body.toString().getBytes(bodyCharset);
                    }
                }
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)bodyBytes.length);
            }
        }
    }

    private void setCookies(HttpResponse httpResponse, DefaultFullHttpResponse response) {
        if (httpResponse.getCookieList() != null) {
            ArrayList<DefaultCookie> cookieValues = new ArrayList<DefaultCookie>();
            for (org.mockserver.model.Cookie cookie : httpResponse.getCookieList()) {
                if (this.cookieHeaderAlreadyExists(httpResponse, cookie)) continue;
                cookieValues.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
            }
            for (Cookie cookie : cookieValues) {
                response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.LAX.encode(cookie));
            }
        }
    }

    private boolean cookieHeaderAlreadyExists(HttpResponse httpResponse, org.mockserver.model.Cookie cookieValue) {
        List<String> setCookieHeaders = httpResponse.getHeader(HttpHeaderNames.SET_COOKIE.toString());
        for (String setCookieHeader : setCookieHeaders) {
            String existingCookieName = ClientCookieDecoder.LAX.decode(setCookieHeader).name();
            String existingCookieValue = ClientCookieDecoder.LAX.decode(setCookieHeader).value();
            if (!existingCookieName.equalsIgnoreCase(cookieValue.getName().getValue()) || !existingCookieValue.equalsIgnoreCase(cookieValue.getValue().getValue())) continue;
            return true;
        }
        return false;
    }
}

