/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.mockserver.echo.http.EchoServerInitializer;
import org.mockserver.filters.MockServerEventLog;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpResponse;
import org.mockserver.scheduler.Scheduler;
import org.mockserver.stop.Stoppable;

public class EchoServer
implements Stoppable {
    static final MockServerLogger mockServerLogger = new MockServerLogger(EchoServer.class);
    static final AttributeKey<MockServerEventLog> LOG_FILTER = AttributeKey.valueOf((String)"SERVER_LOG_FILTER");
    static final AttributeKey<NextResponse> NEXT_RESPONSE = AttributeKey.valueOf((String)"NEXT_RESPONSE");
    static final AttributeKey<OnlyResponse> ONLY_RESPONSE = AttributeKey.valueOf((String)"ONLY_RESPONSE");
    private final Scheduler scheduler = new Scheduler();
    private final MockServerEventLog logFilter = new MockServerEventLog(mockServerLogger, this.scheduler);
    private final NextResponse nextResponse = new NextResponse();
    private final OnlyResponse onlyResponse = new OnlyResponse();
    private final NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
    private final SettableFuture<Integer> boundPort = SettableFuture.create();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public EchoServer(boolean secure) {
        this(secure, null);
    }

    public EchoServer(final boolean secure, final Error error) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                EchoServer.this.bossGroup = (EventLoopGroup)new NioEventLoopGroup(1);
                EchoServer.this.workerGroup = (EventLoopGroup)new NioEventLoopGroup();
                ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(EchoServer.this.bossGroup, EchoServer.this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(EchoServer.class))).childHandler((ChannelHandler)new EchoServerInitializer(mockServerLogger, secure, error)).childAttr(LOG_FILTER, (Object)EchoServer.this.logFilter).childAttr(NEXT_RESPONSE, (Object)EchoServer.this.nextResponse).childAttr(ONLY_RESPONSE, (Object)EchoServer.this.onlyResponse).bind(0).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            EchoServer.this.boundPort.set((Object)((InetSocketAddress)future.channel().localAddress()).getPort());
                        } else {
                            EchoServer.this.boundPort.setException(future.cause());
                            EchoServer.this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                        }
                    }
                });
            }
        }, "MockServer EchoServer Thread").start();
        try {
            this.boundPort.get();
            TimeUnit.MILLISECONDS.sleep(5L);
        }
        catch (Exception e) {
            mockServerLogger.error("Exception while waiting for proxy to complete starting up", e);
        }
    }

    @Override
    public void stop() {
        this.scheduler.shutdown();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.eventLoopGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.stop();
    }

    public Integer getPort() {
        try {
            return (Integer)this.boundPort.get();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public MockServerEventLog requestLogFilter() {
        return this.logFilter;
    }

    public EchoServer withNextResponse(HttpResponse ... httpResponses) {
        this.nextResponse.httpResponse.addAll(Arrays.asList(httpResponses));
        return this;
    }

    public EchoServer withOnlyResponse(HttpResponse httpResponse) {
        this.onlyResponse.httpResponse = httpResponse;
        return this;
    }

    public class OnlyResponse {
        public HttpResponse httpResponse;
    }

    public class NextResponse {
        public final Queue<HttpResponse> httpResponse = new LinkedList<HttpResponse>();
    }

    public static enum Error {
        CLOSE_CONNECTION,
        LARGER_CONTENT_LENGTH,
        SMALLER_CONTENT_LENGTH,
        RANDOM_BYTES_RESPONSE;

    }
}

