/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mappers;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.logging.MockServerLogger;

public class ContentTypeMapper {
    public static final Charset DEFAULT_HTTP_CHARACTER_SET = CharsetUtil.ISO_8859_1;
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(ContentTypeMapper.class);
    private static final Set<String> UTF_8_CONTENT_TYPES = ImmutableSet.builder().add((Object)"application/atom+xml").add((Object)"application/ecmascript").add((Object)"application/javascript").add((Object)"application/json").add((Object)"application/jsonml+json").add((Object)"application/lost+xml").add((Object)"application/wsdl+xml").add((Object)"application/xaml+xml").add((Object)"application/xhtml+xml").add((Object)"application/xml").add((Object)"application/xml-dtd").add((Object)"application/xop+xml").add((Object)"application/xslt+xml").add((Object)"application/xspf+xml").add((Object)"application/x-www-form-urlencoded").add((Object)"image/svg+xml").add((Object)"text/css").add((Object)"text/csv").add((Object)"text/html").add((Object)"text/plain").add((Object)"text/richtext").add((Object)"text/sgml").add((Object)"text/tab-separated-values").add((Object)"text/x-fortran").add((Object)"text/x-java-source").build();

    public static boolean isBinary(String contentTypeHeader) {
        boolean binary = false;
        if (!Strings.isNullOrEmpty((String)contentTypeHeader)) {
            boolean utf8Body;
            String contentType = contentTypeHeader.toLowerCase();
            boolean bl = utf8Body = contentType.contains("utf-8") || contentType.contains("utf8") || contentType.contains("text") || contentType.contains("javascript") || contentType.contains("json") || contentType.contains("ecmascript") || contentType.contains("css") || contentType.contains("csv") || contentType.contains("html") || contentType.contains("xhtml") || contentType.contains("form") || contentType.contains("urlencoded") || contentType.contains("xml");
            if (!utf8Body) {
                binary = contentType.contains("ogg") || contentType.contains("audio") || contentType.contains("video") || contentType.contains("image") || contentType.contains("pdf") || contentType.contains("postscript") || contentType.contains("font") || contentType.contains("woff") || contentType.contains("model") || contentType.contains("zip") || contentType.contains("gzip") || contentType.contains("nacl") || contentType.contains("pnacl") || contentType.contains("vnd") || contentType.contains("application");
            }
        }
        return binary;
    }

    public static Charset getCharsetFromContentTypeHeader(String contentType) {
        Charset charset = DEFAULT_HTTP_CHARACTER_SET;
        if (contentType != null) {
            String charsetName = StringUtils.substringAfterLast((String)contentType, (String)(HttpHeaderValues.CHARSET.toString() + '=')).replaceAll("\"", "");
            if (!Strings.isNullOrEmpty((String)charsetName)) {
                try {
                    charset = Charset.forName(charsetName);
                }
                catch (UnsupportedCharsetException uce) {
                    MOCK_SERVER_LOGGER.warn("Unsupported character set {} in Content-Type header: {}.", StringUtils.substringAfterLast((String)contentType, (String)(HttpHeaderValues.CHARSET.toString() + 61)), contentType);
                }
                catch (IllegalCharsetNameException icne) {
                    MOCK_SERVER_LOGGER.warn("Illegal character set {} in Content-Type header: {}.", StringUtils.substringAfterLast((String)contentType, (String)(HttpHeaderValues.CHARSET.toString() + 61)), contentType);
                }
            } else if (UTF_8_CONTENT_TYPES.contains(contentType)) {
                charset = CharsetUtil.UTF_8;
            }
        }
        return charset;
    }
}

