/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.model.HttpRequest;
import org.mockserver.validator.xmlschema.XmlSchemaValidator;

public class XmlSchemaMatcher
extends BodyMatcher<String> {
    private final MockServerLogger mockServerLogger;
    private String schema;
    private XmlSchemaValidator xmlSchemaValidator;

    public XmlSchemaMatcher(MockServerLogger mockServerLogger, String schema) {
        this.mockServerLogger = mockServerLogger;
        this.schema = schema;
        this.xmlSchemaValidator = new XmlSchemaValidator(mockServerLogger, schema);
    }

    @Override
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return new String[]{"logger", "xmlSchemaValidator"};
    }

    @Override
    public boolean matches(HttpRequest context, String matched) {
        boolean result = false;
        try {
            String validation = this.xmlSchemaValidator.isValid(matched);
            result = validation.isEmpty();
            if (!result) {
                this.mockServerLogger.trace(context, "Failed to match [{}] with schema [{}] because [{}]", matched, this.schema, validation);
            }
        }
        catch (Exception e) {
            this.mockServerLogger.trace(context, "Failed to match [{}] with schema [{}] because [{}]", matched, this.schema, e.getMessage());
        }
        return this.not != result;
    }
}

