/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.PortBinding;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.Serializer;

public class PortBindingSerializer
implements Serializer<PortBinding> {
    private final MockServerLogger mockServerLogger;
    private ObjectMapper objectMapper = ObjectMapperFactory.createObjectMapper();

    public PortBindingSerializer(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
    }

    @Override
    public String serialize(PortBinding portBinding) {
        try {
            return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)portBinding);
        }
        catch (Exception e) {
            this.mockServerLogger.error(String.format("Exception while serializing portBinding to JSON with value %s", portBinding), e);
            throw new RuntimeException(String.format("Exception while serializing portBinding to JSON with value %s", portBinding), e);
        }
    }

    @Override
    public PortBinding deserialize(String jsonPortBinding) {
        PortBinding portBinding = null;
        if (jsonPortBinding != null && !jsonPortBinding.isEmpty()) {
            try {
                portBinding = (PortBinding)this.objectMapper.readValue(jsonPortBinding, PortBinding.class);
            }
            catch (Exception e) {
                this.mockServerLogger.error((HttpRequest)null, (Throwable)e, "exception while parsing {}for PortBinding", jsonPortBinding);
                throw new RuntimeException("Exception while parsing PortBinding for [" + jsonPortBinding + "]", e);
            }
        }
        return portBinding;
    }

    @Override
    public Class<PortBinding> supportsType() {
        return PortBinding.class;
    }
}

