/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.java;

import com.google.common.base.Strings;
import org.mockserver.character.Character;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.serialization.java.ToJavaSerializer;

public class HttpClassCallbackToJavaSerializer
implements ToJavaSerializer<HttpClassCallback> {
    @Override
    public String serialize(int numberOfSpacesToIndent, HttpClassCallback httpClassCallback) {
        StringBuffer output = new StringBuffer();
        if (httpClassCallback != null) {
            this.appendNewLineAndIndent(numberOfSpacesToIndent * 8, output).append("callback()");
            if (httpClassCallback.getCallbackClass() != null) {
                this.appendNewLineAndIndent((numberOfSpacesToIndent + 1) * 8, output).append(".withCallbackClass(\"").append(httpClassCallback.getCallbackClass()).append("\")");
            }
        }
        return output.toString();
    }

    private StringBuffer appendNewLineAndIndent(int numberOfSpacesToIndent, StringBuffer output) {
        return output.append(Character.NEW_LINE).append(Strings.padStart((String)"", (int)numberOfSpacesToIndent, (char)' '));
    }
}

