/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.servlet.responsewriter;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import javax.servlet.http.HttpServletResponse;
import org.mockserver.Version;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.mappers.MockServerResponseToHttpServletResponseEncoder;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;

public class ServletResponseWriter
extends ResponseWriter {
    private final HttpServletResponse httpServletResponse;
    private MockServerResponseToHttpServletResponseEncoder mockServerResponseToHttpServletResponseEncoder = new MockServerResponseToHttpServletResponseEncoder();
    private CORSHeaders addCORSHeaders = new CORSHeaders();

    public ServletResponseWriter(HttpServletResponse httpServletResponse) {
        this.httpServletResponse = httpServletResponse;
    }

    @Override
    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    @Override
    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(responseStatus.code()).withReasonPhrase(responseStatus.reasonPhrase()).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; charset=utf-8"));
        }
        this.writeResponse(request, response, true);
    }

    @Override
    public void writeResponse(HttpRequest request, HttpResponse response, boolean apiResponse) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders.addCORSHeaders(request, response);
        } else if (apiResponse && ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders.addCORSHeaders(request, response);
        }
        if (apiResponse) {
            response.withHeader("version", Version.getVersion());
            String path = request.getPath().getValue();
            if (!path.startsWith("/mockserver")) {
                response.withHeader("deprecated", "\"" + path + "\" is deprecated use \"" + "/mockserver" + path + "\" instead");
            }
        }
        this.addConnectionHeader(request, response);
        this.mockServerResponseToHttpServletResponseEncoder.mapMockServerResponseToHttpServletResponse(response, this.httpServletResponse);
    }
}

