/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.url;

import java.io.ByteArrayOutputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class URLEncoder {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(URLEncoder.class);
    private static final int[] urlAllowedCharacters = new int[]{45, 46, 95, 126, 33, 36, 38, 39, 40, 41, 42, 43, 44, 59, 61, 58, 64, 47, 63};

    public static String encodeURL(String input) {
        try {
            byte[] sourceBytes = URLDecoder.decode(input, StandardCharsets.UTF_8.name()).getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(sourceBytes.length);
            for (int n : sourceBytes) {
                int b = n;
                if (b < 0) {
                    b += 256;
                }
                if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || Arrays.binarySearch(urlAllowedCharacters, b) >= 0) {
                    bos.write(b);
                    continue;
                }
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
            }
            return new String(bos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            MOCK_SERVER_LOGGER.trace("Exception while decoding or encoding url [" + input + "]", e);
            return input;
        }
    }

    static {
        Arrays.sort(urlAllowedCharacters);
        if (MOCK_SERVER_LOGGER.isEnabled(Level.TRACE)) {
            for (int i = 0; i < urlAllowedCharacters.length; ++i) {
                MOCK_SERVER_LOGGER.trace("urlAllowedCharacters[" + i + "] = " + (char)urlAllowedCharacters[i], new Object[0]);
            }
        }
    }
}

