/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.websocket;

import com.google.common.base.Strings;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import org.mockserver.codec.mappers.FullHttpResponseToMockServerResponse;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.websocket.WebSocketClient;
import org.mockserver.websocket.WebSocketException;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final WebSocketClient webSocketClient;
    private final WebSocketClientHandshaker handshaker;
    private final MockServerLogger mockServerLogger = new MockServerLogger(((Object)((Object)this)).getClass());

    WebSocketClientHandler(InetSocketAddress serverAddress, String contextPath, WebSocketClient webSocketClient) throws URISyntaxException {
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI("ws://" + serverAddress.getHostName() + ":" + serverAddress.getPort() + this.cleanContextPath(contextPath) + "/_mockserver_callback_websocket"), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders(), (int)Integer.MAX_VALUE);
        this.webSocketClient = webSocketClient;
    }

    private String cleanContextPath(String contextPath) {
        if (!Strings.isNullOrEmpty((String)contextPath)) {
            return (!contextPath.startsWith("/") ? "/" : "") + contextPath;
        }
        return "";
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.mockServerLogger.trace("web socket client disconnected", new Object[0]);
    }

    public void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (msg instanceof FullHttpResponse) {
            FullHttpResponse httpResponse = (FullHttpResponse)msg;
            SettableFuture registrationFuture = (SettableFuture)ch.attr(WebSocketClient.REGISTRATION_FUTURE).get();
            if (httpResponse.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true) && !this.handshaker.isHandshakeComplete()) {
                this.handshaker.finishHandshake(ch, httpResponse);
                String clientRegistrationId = httpResponse.headers().get("X-CLIENT-REGISTRATION-ID");
                registrationFuture.set((Object)clientRegistrationId);
                this.mockServerLogger.trace("web socket client " + clientRegistrationId + " connected!", new Object[0]);
            } else if (httpResponse.status().equals((Object)HttpResponseStatus.NOT_IMPLEMENTED)) {
                String message = this.readRequestBody(httpResponse);
                registrationFuture.setException((Throwable)new WebSocketException(message));
                this.mockServerLogger.warn(message);
            } else {
                registrationFuture.setException((Throwable)new WebSocketException("Unsupported web socket message " + new FullHttpResponseToMockServerResponse().mapMockServerResponseToFullHttpResponse(httpResponse)));
            }
        } else if (msg instanceof WebSocketFrame) {
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof TextWebSocketFrame) {
                this.webSocketClient.receivedTextWebSocketFrame((TextWebSocketFrame)frame);
            } else if (frame instanceof PingWebSocketFrame) {
                ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
            } else if (frame instanceof CloseWebSocketFrame) {
                this.mockServerLogger.trace("web socket client received request to close", new Object[0]);
                ch.close();
            }
        }
    }

    private String readRequestBody(FullHttpResponse fullHttpResponse) {
        if (fullHttpResponse.content().readableBytes() > 0) {
            byte[] bodyBytes = new byte[fullHttpResponse.content().readableBytes()];
            fullHttpResponse.content().readBytes(bodyBytes);
            Charset requestCharset = ContentTypeMapper.getCharsetFromContentTypeHeader(fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
            return new String(bodyBytes, requestCharset);
        }
        return "";
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.mockServerLogger.error("web socket client caught exception", cause);
        SettableFuture registrationFuture = (SettableFuture)ctx.channel().attr(WebSocketClient.REGISTRATION_FUTURE).get();
        if (!registrationFuture.isDone()) {
            registrationFuture.setException(cause);
        }
        ctx.close();
    }
}

