/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.sun.jna.Pointer;
import java.security.MessageDigest;

class MessageDigestCallback
implements CAPI.mongocrypt_hash_fn {
    private final String algorithm;

    MessageDigestCallback(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean hash(Pointer ctx, CAPI.mongocrypt_binary_t in, CAPI.mongocrypt_binary_t out, CAPI.mongocrypt_status_t status) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(this.algorithm);
            messageDigest.update(CAPIHelper.toByteArray(in));
            byte[] digest = messageDigest.digest();
            CAPIHelper.writeByteArrayToBinary(out, digest);
            return true;
        }
        catch (Exception e) {
            CAPI.mongocrypt_status_set(status, 1, 0, new CAPI.cstring(e.toString()), -1);
            return false;
        }
    }
}

