/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal.crypt;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.internal.capi.MongoCryptHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import java.io.Closeable;
import java.util.Map;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;
import reactor.core.publisher.Mono;

class CommandMarker
implements Closeable {
    @Nullable
    private final MongoClient client;
    @Nullable
    private final ProcessBuilder processBuilder;

    CommandMarker(MongoCrypt mongoCrypt, AutoEncryptionSettings settings) {
        if (MongoCryptHelper.isMongocryptdSpawningDisabled((String)mongoCrypt.getCryptSharedLibVersionString(), (AutoEncryptionSettings)settings)) {
            this.processBuilder = null;
            this.client = null;
        } else {
            Map extraOptions = settings.getExtraOptions();
            boolean mongocryptdBypassSpawn = extraOptions.getOrDefault("mongocryptdBypassSpawn", false);
            if (!mongocryptdBypassSpawn) {
                this.processBuilder = MongoCryptHelper.createProcessBuilder((Map)extraOptions);
                MongoCryptHelper.startProcess((ProcessBuilder)this.processBuilder);
            } else {
                this.processBuilder = null;
            }
            this.client = MongoClients.create(MongoCryptHelper.createMongocryptdClientSettings((String)((String)extraOptions.get("mongocryptdURI"))));
        }
    }

    Mono<RawBsonDocument> mark(String databaseName, RawBsonDocument command) {
        if (this.client != null) {
            return this.runCommand(databaseName, command).onErrorResume(Throwable.class, e -> {
                if (this.processBuilder == null) {
                    throw MongoException.fromThrowable((Throwable)e);
                }
                return Mono.fromRunnable(() -> MongoCryptHelper.startProcess((ProcessBuilder)this.processBuilder)).then(this.runCommand(databaseName, command));
            }).onErrorMap(t -> new MongoClientException("Exception in encryption library: " + t.getMessage(), t));
        }
        return Mono.fromCallable(() -> command);
    }

    private Mono<RawBsonDocument> runCommand(String databaseName, RawBsonDocument command) {
        Assertions.assertNotNull((Object)this.client);
        return Mono.from(this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)command, RawBsonDocument.class));
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

