/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import org.mustangproject.XMLTools;
import org.mustangproject.ZUGFeRD.IReferencedDocument;
import org.mustangproject.util.NodeMap;
import org.w3c.dom.Node;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class ReferencedDocument
implements IReferencedDocument {
    String issuerAssignedID;
    String typeCode;
    String referenceTypeCode;
    Date formattedIssueDateTime;

    public ReferencedDocument(String issuerAssignedID, String typeCode, String referenceTypeCode) {
        this(issuerAssignedID);
        this.typeCode = typeCode;
        this.referenceTypeCode = referenceTypeCode;
    }

    public ReferencedDocument(String issuerAssignedID, String typeCode, String referenceTypeCode, Date formattedIssueDateTime) {
        this(issuerAssignedID, typeCode, referenceTypeCode);
        this.formattedIssueDateTime = formattedIssueDateTime;
    }

    public ReferencedDocument(String issuerAssignedID, String referenceTypeCode) {
        this(issuerAssignedID, "916", referenceTypeCode);
    }

    public ReferencedDocument(String issuerAssingedID, Date formattedIssueDateTime) {
        this(issuerAssingedID);
        this.formattedIssueDateTime = formattedIssueDateTime;
    }

    public ReferencedDocument(String issuerAssignedID) {
        this.issuerAssignedID = issuerAssignedID;
    }

    public void setIssuerAssignedID(String issuerAssignedID) {
        this.issuerAssignedID = issuerAssignedID;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public void setReferenceTypeCode(String referenceTypeCode) {
        this.referenceTypeCode = referenceTypeCode;
    }

    public void setFormattedIssueDateTime(Date formattedIssueDateTime) {
        this.formattedIssueDateTime = formattedIssueDateTime;
    }

    @Override
    public String getIssuerAssignedID() {
        return this.issuerAssignedID;
    }

    @Override
    public String getTypeCode() {
        return this.typeCode;
    }

    @Override
    public String getReferenceTypeCode() {
        return this.referenceTypeCode;
    }

    @Override
    public Date getFormattedIssueDateTime() {
        return this.formattedIssueDateTime;
    }

    public static ReferencedDocument fromNode(Node node) {
        if (!node.hasChildNodes()) {
            return null;
        }
        NodeMap nodes = new NodeMap(node);
        return new ReferencedDocument(nodes.getAsStringOrNull("IssuerAssignedID", "ID"), nodes.getAsStringOrNull("TypeCode", "DocumentTypeCode"), nodes.getAsStringOrNull("ReferenceTypeCode"), XMLTools.tryDate(nodes.getAsStringOrNull("FormattedIssueDateTime")));
    }
}

