/*
 * Decompiled with CFR 0.152.
 */
package org.mustangproject.ZUGFeRD;

import java.text.SimpleDateFormat;
import java.util.Date;

public enum ZUGFeRDDateFormat {
    MONTH_OF_YEAR("610", new SimpleDateFormat("yyyyMM")),
    WEEK_OF_YEAR("616", new SimpleDateFormat("yyyyww")),
    DATE("102", new SimpleDateFormat("yyyyMMdd"));

    private String dateTimeType;
    private SimpleDateFormat formatter;
    private static final String QDT_FORMAT = "<qdt:DateTimeString format=\"%s\">%s</qdt:DateTimeString>";
    private static final String UDT_FORMAT = "<udt:DateTimeString format=\"%s\">%s</udt:DateTimeString>";

    private ZUGFeRDDateFormat(String dateTimeType, SimpleDateFormat formatter) {
        this.dateTimeType = dateTimeType;
        this.formatter = formatter;
    }

    public String getDateTimeType() {
        return this.dateTimeType;
    }

    public SimpleDateFormat getFormatter() {
        return this.formatter;
    }

    public String simpleFormat(Date date) {
        return this.getFormatter().format(date);
    }

    public String qdtFormat(Date date) {
        return String.format(QDT_FORMAT, this.getDateTimeType(), this.getFormatter().format(date));
    }

    public String udtFormat(Date date) {
        return String.format(UDT_FORMAT, this.getDateTimeType(), this.getFormatter().format(date));
    }
}

