/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.BoltProtocolVersion;
import org.neo4j.jdbc.internal.shaded.bolt.observation.BoltExchangeObservation;
import org.neo4j.jdbc.internal.shaded.bolt.observation.HttpExchangeObservation;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ImmutableObservation;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ObservationProvider;

final class BoltConnectionObservations {
    private BoltConnectionObservations() {
    }

    static enum NoopBoltObservationProvider implements ObservationProvider
    {
        INSTANCE;


        @Override
        public BoltExchangeObservation boltExchange(ImmutableObservation observationParent, String host, int port, BoltProtocolVersion boltVersion, BiConsumer<String, String> setter) {
            return NoopBoltExchangeObservation.INSTANCE;
        }

        @Override
        public HttpExchangeObservation httpExchange(ImmutableObservation observationParent, URI uri, String method, String uriTemplate, BiConsumer<String, String> setter) {
            return NoopHttpExchangeObservation.INSTANCE;
        }

        @Override
        public ImmutableObservation scopedObservation() {
            return NoopObservation.INSTANCE;
        }

        @Override
        public <T> T supplyInScope(ImmutableObservation observation, Supplier<T> supplier) {
            return supplier.get();
        }
    }

    static enum NoopObservation implements ImmutableObservation
    {
        INSTANCE;

    }

    static enum NoopHttpExchangeObservation implements HttpExchangeObservation
    {
        INSTANCE;


        @Override
        public HttpExchangeObservation onHeaders(Map<String, List<String>> headers) {
            return this;
        }

        @Override
        public HttpExchangeObservation onResponse(HttpExchangeObservation.Response response) {
            return this;
        }

        @Override
        public HttpExchangeObservation error(Throwable error) {
            return this;
        }

        @Override
        public void stop() {
        }
    }

    static enum NoopBoltExchangeObservation implements BoltExchangeObservation
    {
        INSTANCE;


        @Override
        public BoltExchangeObservation onWrite(String messageName) {
            return this;
        }

        @Override
        public BoltExchangeObservation onRecord() {
            return this;
        }

        @Override
        public BoltExchangeObservation onSummary(String messageName) {
            return this;
        }

        @Override
        public BoltExchangeObservation error(Throwable error) {
            return this;
        }

        @Override
        public void stop() {
        }
    }
}

