/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.jdbc.GqlStatusObject;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltGqlErrorException;
import org.neo4j.jdbc.values.Values;

final class GqlStatusObjectImpl
implements GqlStatusObject {
    private static final long serialVersionUID = 2325394968498244944L;
    private final String gqlStatus;
    private final String statusDescription;
    private final HashMap<String, String> diagnosticRecord;
    private final GqlStatusObject cause;

    private GqlStatusObjectImpl(String gqlStatus, String statusDescription, HashMap<String, String> diagnosticRecord, GqlStatusObject cause) {
        this.gqlStatus = gqlStatus;
        this.statusDescription = statusDescription;
        this.diagnosticRecord = diagnosticRecord;
        this.cause = cause;
    }

    static GqlStatusObject of(BoltGqlErrorException gqlErrorException) {
        GqlStatusObject cause = gqlErrorException.gqlCause().map(GqlStatusObjectImpl::of).orElse(null);
        return new GqlStatusObjectImpl(gqlErrorException.gqlStatus(), gqlErrorException.statusDescription(), GqlStatusObjectImpl.adaptDiagnosticRecord(gqlErrorException), cause);
    }

    static HashMap<String, String> adaptDiagnosticRecord(BoltGqlErrorException gqlErrorException) {
        return gqlErrorException.diagnosticRecord().entrySet().stream().collect(Collectors.collectingAndThen(Collectors.toMap(Map.Entry::getKey, e -> Values.value(e.getValue()).asObject().toString()), m -> {
            HashMap hashMap;
            if (m instanceof HashMap) {
                HashMap hm = (HashMap)m;
                hashMap = hm;
            } else {
                hashMap = new HashMap(m);
            }
            return hashMap;
        }));
    }

    @Override
    public Optional<GqlStatusObject> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public String gqlStatus() {
        return this.gqlStatus;
    }

    @Override
    public String statusDescription() {
        return this.statusDescription;
    }

    @Override
    public Map<String, String> diagnosticRecord() {
        return Map.copyOf(this.diagnosticRecord);
    }
}

