/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DecimalNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.FloatNode;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import org.neo4j.jdbc.JSONMapper;
import org.neo4j.jdbc.values.BooleanValue;
import org.neo4j.jdbc.values.BytesValue;
import org.neo4j.jdbc.values.DateTimeValue;
import org.neo4j.jdbc.values.DateValue;
import org.neo4j.jdbc.values.DurationValue;
import org.neo4j.jdbc.values.FloatValue;
import org.neo4j.jdbc.values.IntegerValue;
import org.neo4j.jdbc.values.ListValue;
import org.neo4j.jdbc.values.LocalDateTimeValue;
import org.neo4j.jdbc.values.LocalTimeValue;
import org.neo4j.jdbc.values.MapValue;
import org.neo4j.jdbc.values.Node;
import org.neo4j.jdbc.values.NodeValue;
import org.neo4j.jdbc.values.NullValue;
import org.neo4j.jdbc.values.Path;
import org.neo4j.jdbc.values.PathValue;
import org.neo4j.jdbc.values.Point;
import org.neo4j.jdbc.values.PointValue;
import org.neo4j.jdbc.values.Relationship;
import org.neo4j.jdbc.values.RelationshipValue;
import org.neo4j.jdbc.values.StringValue;
import org.neo4j.jdbc.values.TimeValue;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

final class JacksonJSONMapperImpl
implements JSONMapper<JsonNode> {
    private final ObjectMapper objectMapper = new ObjectMapper();

    JacksonJSONMapperImpl() {
    }

    @Override
    public JsonNode toJson(Value value) {
        if (value instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)value;
            return BooleanNode.valueOf((boolean)booleanValue.asBoolean());
        }
        if (value instanceof BytesValue) {
            BytesValue bytesValue = (BytesValue)value;
            return TextNode.valueOf((String)Base64.getEncoder().encodeToString(bytesValue.asByteArray()));
        }
        if (value instanceof DateTimeValue) {
            DateTimeValue dateTimeValue = (DateTimeValue)value;
            String textValue = dateTimeValue.asZonedDateTime().getZone().normalized() instanceof ZoneOffset ? DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(dateTimeValue.asOffsetDateTime()) : DateTimeFormatter.ISO_ZONED_DATE_TIME.format(dateTimeValue.asZonedDateTime());
            return TextNode.valueOf((String)textValue);
        }
        if (value instanceof DateValue) {
            DateValue dateValue = (DateValue)value;
            return TextNode.valueOf((String)DateTimeFormatter.ISO_LOCAL_DATE.format((TemporalAccessor)dateValue.asObject()));
        }
        if (value instanceof DurationValue) {
            DurationValue durationValue = (DurationValue)value;
            return TextNode.valueOf((String)durationValue.toString().replace("DURATION '", "").replace("'", ""));
        }
        if (value instanceof FloatValue) {
            FloatValue floatValue = (FloatValue)value;
            return DoubleNode.valueOf((double)floatValue.asDouble());
        }
        if (value instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)value;
            return LongNode.valueOf((long)integerValue.asLong());
        }
        if (value instanceof ListValue) {
            ListValue listValue = (ListValue)value;
            return this.mapList(listValue);
        }
        if (value instanceof LocalDateTimeValue) {
            LocalDateTimeValue localDateTimeValue = (LocalDateTimeValue)value;
            return TextNode.valueOf((String)DateTimeFormatter.ISO_LOCAL_DATE_TIME.format((TemporalAccessor)localDateTimeValue.asObject()));
        }
        if (value instanceof LocalTimeValue) {
            LocalTimeValue localTimeValue = (LocalTimeValue)value;
            return TextNode.valueOf((String)DateTimeFormatter.ISO_LOCAL_TIME.format((TemporalAccessor)localTimeValue.asObject()));
        }
        if (value instanceof MapValue) {
            MapValue mapValue = (MapValue)value;
            return this.mapMap(mapValue);
        }
        if (value instanceof NodeValue) {
            NodeValue nodeValue = (NodeValue)value;
            return this.mapNode(nodeValue.asNode());
        }
        if (value == null || value instanceof NullValue) {
            return NullNode.getInstance();
        }
        if (value instanceof PathValue) {
            PathValue pathValue = (PathValue)value;
            return this.mapPath(pathValue.asPath());
        }
        if (value instanceof PointValue) {
            PointValue pointValue = (PointValue)value;
            Point point = pointValue.asPoint();
            boolean is3d = !Double.isNaN(point.z());
            return TextNode.valueOf((String)("SRID=" + point.srid() + ";POINT" + (is3d ? " Z " : " ") + "(" + point.x() + " " + point.y() + (String)(is3d ? " " + point.z() + ")" : ")")));
        }
        if (value instanceof RelationshipValue) {
            RelationshipValue relationshipValue = (RelationshipValue)value;
            return this.mapRelationship(relationshipValue.asRelationship());
        }
        if (value instanceof StringValue) {
            StringValue stringValue = (StringValue)value;
            return TextNode.valueOf((String)stringValue.asString());
        }
        if (value instanceof TimeValue) {
            TimeValue timeValue = (TimeValue)value;
            return TextNode.valueOf((String)DateTimeFormatter.ISO_OFFSET_TIME.format((TemporalAccessor)timeValue.asObject()));
        }
        throw new UnsupportedOperationException("Cannot map %s to a %s".formatted(value, this.getBaseType().getSimpleName()));
    }

    @Override
    public Value fromJson(Object in) {
        if (in == null) {
            return Values.NULL;
        }
        if (!(in instanceof JsonNode)) {
            throw new UnsupportedOperationException("Cannot map objects of type %s to %s".formatted(in.getClass().getName(), this.getBaseType().getSimpleName()));
        }
        JsonNode json = (JsonNode)in;
        if (json.isNull()) {
            return Values.NULL;
        }
        if (json instanceof BooleanNode) {
            BooleanNode booleanNode = (BooleanNode)json;
            return Values.value(booleanNode.booleanValue());
        }
        if (json instanceof BinaryNode) {
            BinaryNode binaryNode = (BinaryNode)json;
            return Values.value(Base64.getEncoder().encodeToString(binaryNode.binaryValue()));
        }
        if (json instanceof DecimalNode) {
            DecimalNode decimalNode = (DecimalNode)json;
            return Values.value(decimalNode.decimalValue().toString());
        }
        if (json instanceof DoubleNode) {
            DoubleNode doubleNode = (DoubleNode)json;
            return Values.value(doubleNode.doubleValue());
        }
        if (json instanceof FloatNode) {
            FloatNode floatNode = (FloatNode)json;
            return Values.value((double)floatNode.floatValue());
        }
        if (json instanceof NumericNode) {
            NumericNode numericNode = (NumericNode)json;
            return Values.value(numericNode.longValue());
        }
        if (json instanceof TextNode) {
            TextNode textNode = (TextNode)json;
            return Values.value(textNode.textValue());
        }
        if (json instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)json;
            LinkedHashMap result = new LinkedHashMap();
            objectNode.forEachEntry((k, v) -> result.put(k, this.fromJson(v)));
            return Values.value(result);
        }
        if (json instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)json;
            ArrayList result = new ArrayList();
            arrayNode.forEach(v -> result.add(this.fromJson(v)));
            return Values.value(result);
        }
        throw new UnsupportedOperationException("Cannot map %s to a %s".formatted(json, Value.class.getSimpleName()));
    }

    @Override
    public Class<JsonNode> getBaseType() {
        return JsonNode.class;
    }

    private JsonNode mapPath(Path path) {
        ArrayNode result = this.objectMapper.createArrayNode();
        result.add(this.mapNode(path.start()));
        path.relationships().forEach(relationship -> result.add(this.mapRelationship((Relationship)relationship)));
        result.add(this.mapNode(path.end()));
        return result;
    }

    private JsonNode mapRelationship(Relationship relationship) {
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("elementId", relationship.elementId());
        result.put("startNodeElementId", relationship.startNodeElementId());
        result.put("endNodeElementId", relationship.endNodeElementId());
        result.put("type", relationship.type());
        ObjectNode properties = this.objectMapper.createObjectNode();
        relationship.keys().forEach(key -> properties.set(key, this.toJson(relationship.get((String)key))));
        result.set("properties", (JsonNode)properties);
        return result;
    }

    private JsonNode mapList(ListValue listValue) {
        ArrayNode result = this.objectMapper.createArrayNode();
        listValue.values().forEach(value -> result.add(this.toJson((Value)value)));
        return result;
    }

    private JsonNode mapMap(MapValue mapValue) {
        ObjectNode result = this.objectMapper.createObjectNode();
        mapValue.keys().forEach(key -> result.set(key, this.toJson(mapValue.get((String)key))));
        return result;
    }

    private JsonNode mapNode(Node node) {
        ObjectNode result = this.objectMapper.createObjectNode();
        result.put("elementId", node.elementId());
        ArrayNode labels = this.objectMapper.createArrayNode();
        node.labels().forEach(arg_0 -> ((ArrayNode)labels).add(arg_0));
        result.set("labels", (JsonNode)labels);
        ObjectNode properties = this.objectMapper.createObjectNode();
        node.keys().forEach(key -> properties.set(key, this.toJson(node.get((String)key))));
        result.set("properties", (JsonNode)properties);
        return result;
    }
}

