/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.jdbc.GqlStatusObject;
import org.neo4j.jdbc.GqlStatusObjectImpl;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltGqlErrorException;

final class Neo4jException
extends SQLException
implements GqlStatusObject {
    private static final long serialVersionUID = 4192957098450787651L;
    private final HashMap<String, String> diagnosticRecord;
    private final GqlStatusObject gqlCause;

    static Args withCause(Throwable cause) {
        return Neo4jException.withMessageAndCause(null, cause);
    }

    static Args withMessageAndCause(String message, Throwable cause) {
        BoltGqlErrorException gqlErrorException;
        if (cause instanceof BoltGqlErrorException && (gqlErrorException = (BoltGqlErrorException)cause).gqlStatus() != null) {
            String sqlState = gqlErrorException.gqlStatus();
            String reason = GQLError.isCatchAll(gqlErrorException) ? String.format("%s (%s)", gqlErrorException.statusDescription(), cause.getMessage()) : gqlErrorException.statusDescription();
            return new Args(reason, sqlState, cause, GqlStatusObjectImpl.adaptDiagnosticRecord(gqlErrorException), gqlErrorException.gqlCause().map(GqlStatusObjectImpl::of).orElse(null));
        }
        return GQLError.$50N42.causedBy(cause).withMessage(message != null ? message : cause.getMessage());
    }

    static Args withInternal(Exception ex) {
        return Neo4jException.withInternal(ex, ex.getMessage());
    }

    static Args withInternal(Exception ex, String msg) {
        return GQLError.$50N00.causedBy(ex).withTemplatedMessage(ex.getClass().getName(), msg);
    }

    static Args withReason(String reason) {
        return GQLError.$50N42.withMessage(reason);
    }

    Neo4jException(Args args) {
        super(args.reason(), args.sqlState(), args.cause());
        HashMap<String, String> hashMap;
        Map<String, String> map = args.diagnosticRecord();
        if (map instanceof HashMap) {
            HashMap hm = (HashMap)map;
            hashMap = hm;
        } else {
            hashMap = new HashMap<String, String>(args.diagnosticRecord());
        }
        this.diagnosticRecord = hashMap;
        this.gqlCause = args.gqlCause();
    }

    @Override
    public String gqlStatus() {
        return super.getSQLState();
    }

    @Override
    public String statusDescription() {
        return super.getMessage();
    }

    @Override
    public Map<String, String> diagnosticRecord() {
        return Map.copyOf(this.diagnosticRecord);
    }

    @Override
    public Optional<GqlStatusObject> cause() {
        return Optional.ofNullable(this.gqlCause);
    }

    record Args(String reason, String sqlState, Throwable cause, Map<String, String> diagnosticRecord, GqlStatusObject gqlCause) {
        Args(String reason, String sqlState, Throwable cause) {
            this(reason, sqlState, cause, Map.of(), null);
        }
    }

    static enum GQLError {
        $08000(""),
        $22000(""),
        $22003("The numeric value %s is outside the required range"),
        $22G03("Invalid value type"),
        $22N01("Invalid type, expected the value %s to be of type %s, but was of type %s"),
        $22N02("You specified a negative numeric value, expected %s to be a positive number but found %s instead"),
        $22N06("Required input missing, %s needs to be specified"),
        $22N11("Invalid argument, cannot process %s"),
        $22N37("Cannot coerce %s to %s"),
        $22N63("The property key %s does not exist"),
        $25N02("Unable to complete transaction, see debug log for details"),
        $25N05("Transaction has been closed"),
        $2DN01("Failed to commit transaction: %s"),
        $2DN03("Failed to terminate transaction: %s"),
        $40N01("Failed to rollback transaction: %s"),
        $42N51("Invalid parameter %s"),
        $50N00("An internal exception has been raised %s: %s"),
        $50N42("An unexpected error has occurred, see debug log for details");

        private final String messageTemplate;
        private static final Map<String, String> PREFIXES;

        private GQLError(String messageTemplate) {
            this.messageTemplate = messageTemplate;
        }

        ErrorAndCause causedBy(Throwable cause) {
            return new ErrorAndCause(this, cause);
        }

        Args withTemplatedMessage(Object ... args) {
            return new ErrorAndCause(this, null).withTemplatedMessage(args);
        }

        Args withMessage(String msg) {
            return new ErrorAndCause(this, null).withMessage(msg);
        }

        private String getPrefix() {
            return PREFIXES.get(this.name().substring(1, 3));
        }

        private static boolean isCatchAll(BoltGqlErrorException ex) {
            if (ex == null) {
                return false;
            }
            if (!$50N00.name().contains(ex.gqlStatus()) && !$50N42.name().contains(ex.gqlStatus())) {
                return false;
            }
            return !Objects.requireNonNullElse(ex.getMessage(), "").equals(ex.statusDescription());
        }

        static {
            PREFIXES = Map.of("22", "data exception", "25", "invalid transaction state", "2D", "invalid transaction termination", "40", "transaction rollback", "42", "syntax error or access rule violation", "50", "general processing exception");
        }

        static final class ErrorAndCause {
            private final GQLError error;
            private final Throwable cause;

            ErrorAndCause(GQLError error, Throwable cause) {
                this.error = error;
                this.cause = cause;
            }

            Args withTemplatedMessage(Object ... args) {
                String template = this.error.getPrefix() + " - " + this.error.messageTemplate;
                return new Args(template.formatted(args), this.error.name().substring(1), this.cause);
            }

            Args withMessage(String msg) {
                String template = this.error.getPrefix() + " - %s";
                return new Args(template.formatted(msg), this.error.name().substring(1), this.cause);
            }
        }
    }
}

