/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelAttributes;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection.ChannelPipelineBuilder;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.ChannelErrorHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.ChunkDecoder;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.InboundMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.inbound.MessageDecoder;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.outbound.OutboundMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.netty.impl.messaging.MessageFormat;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.ChannelPipeline;

public class ChannelPipelineBuilderImpl
implements ChannelPipelineBuilder {
    @Override
    public void build(MessageFormat messageFormat, ChannelPipeline pipeline, LoggingProvider logging, ValueFactory valueFactory) {
        pipeline.addLast(new ChunkDecoder(logging));
        pipeline.addLast(new MessageDecoder());
        Channel channel = pipeline.channel();
        InboundMessageHandler inboundMessageHandler = new InboundMessageHandler(messageFormat, logging, valueFactory);
        ChannelAttributes.addBoltPatchesListener(channel, inboundMessageHandler);
        pipeline.addLast(inboundMessageHandler);
        OutboundMessageHandler outboundMessageHandler = new OutboundMessageHandler(messageFormat, logging, valueFactory);
        ChannelAttributes.addBoltPatchesListener(channel, outboundMessageHandler);
        pipeline.addLast(OutboundMessageHandler.NAME, (ChannelHandler)outboundMessageHandler);
        pipeline.addLast(new ChannelErrorHandler(logging));
    }
}

