/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.netty.impl.async.connection;

import java.util.Objects;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.Channel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.Epoll;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.EpollSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueue;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueueSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUring;
import org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUringSocketChannel;

public record NettyTransport(Type type, Class<? extends Channel> channelClass, boolean fastOpenAvailable) {
    private static final String EPOLL_NAME = "org.neo4j.jdbc.internal.shaded.io.netty.channel.epoll.Epoll";
    private static final String IO_URING_NAME = "org.neo4j.jdbc.internal.shaded.io.netty.channel.uring.IoUring";
    private static final String KQUEUE_NAME = "org.neo4j.jdbc.internal.shaded.io.netty.channel.kqueue.KQueue";

    public NettyTransport {
        Objects.requireNonNull(channelClass);
    }

    public static boolean isEpollAvailable() {
        try {
            Class.forName(EPOLL_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return Epoll.isAvailable();
    }

    public static boolean isIoUringAvailable() {
        try {
            Class.forName(IO_URING_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return IoUring.isAvailable();
    }

    public static boolean isKQueueAvailable() {
        try {
            Class.forName(KQUEUE_NAME);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return KQueue.isAvailable();
    }

    public static NettyTransport nio() {
        return new NettyTransport(Type.NIO, NioSocketChannel.class, false);
    }

    public static NettyTransport epoll() {
        return new NettyTransport(Type.EPOLL, EpollSocketChannel.class, Epoll.isTcpFastOpenClientSideAvailable());
    }

    public static NettyTransport ioUring() {
        return new NettyTransport(Type.IO_URING, IoUringSocketChannel.class, IoUring.isTcpFastOpenClientSideAvailable());
    }

    public static NettyTransport kqueue() {
        return new NettyTransport(Type.KQUEUE, KQueueSocketChannel.class, KQueue.isTcpFastOpenClientSideAvailable());
    }

    public static NettyTransport local() {
        return new NettyTransport(Type.LOCAL, LocalChannel.class, false);
    }

    public static enum Type {
        NIO,
        EPOLL,
        IO_URING,
        KQUEUE,
        LOCAL;

    }
}

