/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.bolt.query_api.impl;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.neo4j.jdbc.internal.shaded.bolt.AccessMode;
import org.neo4j.jdbc.internal.shaded.bolt.LoggingProvider;
import org.neo4j.jdbc.internal.shaded.bolt.ResponseHandler;
import org.neo4j.jdbc.internal.shaded.bolt.exception.BoltClientException;
import org.neo4j.jdbc.internal.shaded.bolt.message.BeginMessage;
import org.neo4j.jdbc.internal.shaded.bolt.observation.ObservationProvider;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.AbstractMessageHandler;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.BeginSummaryImpl;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.HttpContext;
import org.neo4j.jdbc.internal.shaded.bolt.query_api.impl.TransactionInfo;
import org.neo4j.jdbc.internal.shaded.bolt.values.ValueFactory;

final class BeginMessageHandler
extends AbstractMessageHandler<TransactionInfo> {
    private final System.Logger log;
    private final ResponseHandler handler;
    private final HttpContext httpContext;
    private final Supplier<String> authHeaderSupplier;
    private final HttpRequest.BodyPublisher bodyPublisher;
    private final String databaseName;
    private final Duration readTimeout;

    BeginMessageHandler(ResponseHandler handler, HttpContext httpContext, Supplier<String> authHeaderSupplier, BeginMessage message, Duration readTimeout, ValueFactory valueFactory, LoggingProvider logging, ObservationProvider observationProvider) {
        super(httpContext, handler, valueFactory, logging, observationProvider);
        this.log = logging.getLog(this.getClass());
        this.handler = Objects.requireNonNull(handler);
        this.httpContext = Objects.requireNonNull(httpContext);
        this.authHeaderSupplier = Objects.requireNonNull(authHeaderSupplier);
        this.readTimeout = readTimeout;
        if (message.databaseName().isPresent()) {
            this.databaseName = message.databaseName().get();
        } else if (httpContext.defaultDatabase() != null) {
            this.databaseName = httpContext.defaultDatabase();
        } else {
            throw new BoltClientException("Database name must be specified");
        }
        try {
            this.bodyPublisher = BeginMessageHandler.newHttpRequestBodyPublisher(httpContext, message, this.databaseName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected AbstractMessageHandler.ObservationParameters newHttpRequestBuilder(HttpRequest.Builder builder) {
        URI uri = this.httpContext.txUrl(this.databaseName);
        String[] headers = this.httpContext.headers(this.authHeaderSupplier.get());
        builder.uri(uri).headers(headers).POST(this.bodyPublisher);
        if (this.readTimeout != null) {
            builder.timeout(this.readTimeout);
        }
        return new AbstractMessageHandler.ObservationParameters(uri, "POST", HttpContext.TRANSACTION_BASE_URL_TEMPLATE, headers);
    }

    @Override
    protected TransactionInfo handleResponse(HttpResponse<String> response) {
        try {
            TransactionEntry transactionEntry = this.httpContext.json().beanFrom(TransactionEntry.class, response.body());
            String affinity = response.headers().firstValue("neo4j-cluster-affinity").orElse(null);
            TransactionInfo info = new TransactionInfo(this.databaseName, transactionEntry.transaction().id(), Instant.parse(transactionEntry.transaction().expires()), affinity);
            this.handler.onBeginSummary(new BeginSummaryImpl(this.databaseName));
            return info;
        }
        catch (IOException e) {
            throw new BoltClientException("Cannot parse %s to TransactionEntry".formatted(response.body()), e);
        }
    }

    private static HttpRequest.BodyPublisher newHttpRequestBodyPublisher(HttpContext httpContext, BeginMessage message, String databaseName) throws IOException {
        String string;
        String accessMode = message.accessMode() == AccessMode.READ ? "Read" : null;
        String impersonatedUser = message.impersonatedUser().orElse(null);
        ArrayList<String> bookmarks = null;
        if (!message.bookmarks().isEmpty()) {
            bookmarks = new ArrayList<String>(message.bookmarks());
        }
        if (message.transactionType() != null) {
            switch (message.transactionType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case UNCONSTRAINED: {
                    string = "IMPLICIT";
                    break;
                }
                case DEFAULT: {
                    string = null;
                    break;
                }
            }
        } else {
            string = null;
        }
        String txType = string;
        String jsonBody = httpContext.json().asString(new BeginMessageWrapper(accessMode, impersonatedUser, bookmarks, txType));
        return HttpRequest.BodyPublishers.ofString(jsonBody);
    }

    record TransactionEntry(Transaction transaction) {
    }

    record Transaction(String id, String expires) {
    }

    record BeginMessageWrapper(String accessMode, String impersonatedUser, List<String> bookmarks, String txType) {
    }
}

