/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Cypher;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.InternalPropertyImpl;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.MapProjection;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Named;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operation;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Operations;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Parameter;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Property;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PropertyContainer;

@API(status=API.Status.INTERNAL, since="2021.1.0")
abstract class AbstractPropertyContainer
implements PropertyContainer {
    AbstractPropertyContainer() {
    }

    static IllegalStateException noNameException() {
        return new IllegalStateException(Cypher.MESSAGES.getString("assertions.requires-name-for-mutation"));
    }

    @Override
    public final Property property(String name) {
        return InternalPropertyImpl.create((Named)this, name);
    }

    @Override
    public final Property property(String ... names) {
        return InternalPropertyImpl.create((Named)this, names);
    }

    @Override
    public final Property property(Expression lookup) {
        return InternalPropertyImpl.create((Named)this, lookup);
    }

    @Override
    public final Operation mutate(Parameter<?> parameter) {
        return Operations.mutate((Expression)this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), parameter);
    }

    @Override
    public final Operation mutate(MapExpression properties) {
        return Operations.mutate((Expression)this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), properties);
    }

    @Override
    public final Operation set(Parameter<?> parameter) {
        return Operations.set(this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), parameter);
    }

    @Override
    public final Operation set(MapExpression properties) {
        return Operations.set(this.getSymbolicName().orElseThrow(AbstractPropertyContainer::noNameException), properties);
    }

    @Override
    public final MapProjection project(List<Object> entries) {
        return this.project(entries.toArray());
    }

    @Override
    public final MapProjection project(Object ... entries) {
        return this.getRequiredSymbolicName().project(entries);
    }
}

