/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.cypherdsl;

import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Condition;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ExposesWhere;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Expression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.IdentifiableElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ImportingWith;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Match;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Neo4jVersion;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Pattern;
import org.neo4j.jdbc.internal.shaded.cypherdsl.PatternElement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Statement;
import org.neo4j.jdbc.internal.shaded.cypherdsl.SubqueryExpression;
import org.neo4j.jdbc.internal.shaded.cypherdsl.Where;
import org.neo4j.jdbc.internal.shaded.cypherdsl.With;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitable;
import org.neo4j.jdbc.internal.shaded.cypherdsl.ast.Visitor;

@API(status=API.Status.STABLE, since="2023.0.0")
@Neo4jVersion(minimum="5.0")
public final class CountExpression
implements SubqueryExpression,
ExposesWhere<Expression> {
    private final ImportingWith importingWith;
    private final List<Visitable> fragments;
    private final Where innerWhere;

    private CountExpression(ImportingWith optionalWith, List<? extends Visitable> fragments, Where innerWhere) {
        Visitable patternOrUnion;
        Visitable visitable = patternOrUnion = fragments.size() != 1 ? null : fragments.get(0);
        if (patternOrUnion instanceof Statement.UnionQuery && innerWhere != null) {
            throw new IllegalArgumentException("Cannot use a UNION with a WHERE clause inside a COUNT {} expression");
        }
        this.importingWith = optionalWith;
        With imports = optionalWith.imports();
        if (imports != null && patternOrUnion instanceof Pattern) {
            Pattern pattern = (Pattern)patternOrUnion;
            this.fragments = List.of(new Match(false, pattern, innerWhere, null));
            this.innerWhere = null;
        } else if (imports != null && patternOrUnion instanceof Match) {
            Match match = (Match)patternOrUnion;
            this.fragments = List.of(new Match(false, match.pattern, innerWhere, null));
            this.innerWhere = null;
        } else {
            this.fragments = List.copyOf(fragments);
            this.innerWhere = innerWhere;
        }
    }

    static CountExpression count(Statement statement, IdentifiableElement ... imports) {
        return new CountExpression(ImportingWith.of(imports), List.of(statement), null);
    }

    static CountExpression count(Visitable patternOrUnion) {
        return new CountExpression(new ImportingWith(), List.of(patternOrUnion), null);
    }

    static CountExpression count(With optionalWith, Visitable patternOrUnion) {
        return new CountExpression(new ImportingWith(optionalWith, null), List.of(patternOrUnion), null);
    }

    static CountExpression count(List<PatternElement> patternElements, Where innerWhere) {
        return new CountExpression(new ImportingWith(), patternElements, innerWhere);
    }

    @Override
    public CountExpression where(Condition condition) {
        if (this.fragments.size() == 1 && this.fragments.get(0) instanceof Statement) {
            throw new IllegalArgumentException("This count expression is build upon a full statement, adding a condition to it is not supported.");
        }
        return new CountExpression(this.importingWith, this.fragments, new Where(condition));
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.importingWith.accept(visitor);
        this.fragments.forEach(v -> v.accept(visitor));
        Visitable.visitIfNotNull(this.innerWhere, visitor);
        visitor.leave(this);
    }
}

