/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.TableField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class ArrayGet<T>
extends AbstractField<T>
implements QOM.ArrayGet<T> {
    final Field<T[]> array;
    final Field<Integer> index;

    ArrayGet(Field<T[]> array, Field<Integer> index) {
        super(Names.N_ARRAY_GET, Tools.allNotNull(StringUtils.defaultIfNull(array.getDataType().getArrayComponentDataType(), SQLDataType.OTHER), array, index));
        this.array = Tools.nullSafeNotNull(array, SQLDataType.OTHER.array());
        this.index = Tools.nullSafeNotNull(index, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case HSQLDB: {
                if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_STORE_ASSIGNMENT))) {
                    ctx.visit(new Standard());
                    break;
                }
                ctx.visit(DSL.when(DSL.cardinality(this.array).ge(this.index), new Standard()));
                break;
            }
            case TRINO: {
                ctx.visit(DSL.function(Names.N_ELEMENT_AT, this.getDataType(), this.array, this.index));
                break;
            }
            default: {
                ctx.visit(new Standard());
            }
        }
    }

    @Override
    public final Field<T[]> $arg1() {
        return this.array;
    }

    @Override
    public final Field<Integer> $arg2() {
        return this.index;
    }

    @Override
    public final QOM.ArrayGet<T> $arg1(Field<T[]> newValue) {
        return this.$constructor().apply(newValue, (Field<Integer>)this.$arg2());
    }

    @Override
    public final QOM.ArrayGet<T> $arg2(Field<Integer> newValue) {
        return this.$constructor().apply((Field<T[]>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T[]>, ? super Field<Integer>, ? extends QOM.ArrayGet<T>> $constructor() {
        return (a1, a2) -> new ArrayGet((Field<T[]>)a1, (Field<Integer>)a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.ArrayGet) {
            QOM.ArrayGet o = (QOM.ArrayGet)that;
            return StringUtils.equals(this.$array(), o.$array()) && StringUtils.equals(this.$index(), o.$index());
        }
        return super.equals(that);
    }

    private class Standard
    extends AbstractField<T>
    implements QOM.UTransient {
        Standard() {
            super(ArrayGet.this.getQualifiedName(), ArrayGet.this.getDataType());
        }

        @Override
        public void accept(Context<?> ctx) {
            if (ArrayGet.this.array instanceof TableField || Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_STORE_ASSIGNMENT))) {
                ctx.visit(ArrayGet.this.array).sql('[').visit(ArrayGet.this.index).sql(']');
            } else {
                ctx.sql('(').visit(ArrayGet.this.array).sql(')').sql('[').visit(ArrayGet.this.index).sql(']');
            }
        }
    }
}

