/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function1;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.UDTPathField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class Excluded<T>
extends AbstractField<T>
implements QOM.Excluded<T> {
    final Field<T> field;

    Excluded(Field<T> field) {
        super(Names.N_EXCLUDED, Tools.allNotNull(Tools.dataType(field), field));
        this.field = Tools.nullSafeNotNull(field, SQLDataType.OTHER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MARIADB: {
                ctx.visit(Keywords.K_VALUES).sql('(').qualify(false, c -> c.visit(this.field)).sql(')');
                break;
            }
            case MYSQL: {
                ctx.visit(DSL.name("t")).sql('.').qualify(false, c -> c.visit(this.field));
                break;
            }
            default: {
                Table<Record> e;
                Table t = (Table)ctx.data(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE);
                Table<Record> table = e = ctx.data(Tools.ExtendedDataKey.DATA_INSERT_ON_DUPLICATE_KEY_UPDATE) != null ? DSL.table(DSL.name("t")) : DSL.table(Names.N_EXCLUDED);
                if (this.field instanceof UDTPathField) {
                    ctx.scopeRegister(t, false, e).visit(this.field).scopeRegister(t, false, null);
                    break;
                }
                ctx.visit(e).sql('.').qualify(false, c -> c.visit(this.field));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.field;
    }

    @Override
    public final QOM.Excluded<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue);
    }

    @Override
    public final Function1<? super Field<T>, ? extends QOM.Excluded<T>> $constructor() {
        return a1 -> new Excluded(a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Excluded) {
            QOM.Excluded o = (QOM.Excluded)that;
            return StringUtils.equals(this.$field(), o.$field());
        }
        return super.equals(that);
    }
}

