/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.math.BigDecimal;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.SQLDialect;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractAggregateFunction;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;

final class RatioToReport
extends AbstractAggregateFunction<BigDecimal>
implements QOM.RatioToReport {
    private final Field<? extends Number> field;

    RatioToReport(Field<? extends Number> field) {
        super(Names.N_RATIO_TO_REPORT, SQLDataType.DECIMAL, field);
        this.field = field;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: 
            case FIREBIRD: 
            case TRINO: 
            case CUBRID: 
            case DUCKDB: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Tools.castIfNeeded(this.field, switch (ctx.family()) {
                    case SQLDialect.SQLITE -> SQLDataType.DOUBLE;
                    case SQLDialect.FIREBIRD, SQLDialect.TRINO -> SQLDataType.DECIMAL(38, 19);
                    default -> SQLDataType.DECIMAL;
                })).sql(" / ").visit(DSL.sum(this.field));
                this.acceptOverClause(ctx);
                break;
            }
            default: {
                ctx.visit(Names.N_RATIO_TO_REPORT).sql('(').visit(this.field).sql(')');
                this.acceptOverClause(ctx);
            }
        }
    }

    @Override
    public final Field<? extends Number> $field() {
        return this.field;
    }
}

