/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import java.util.Collection;
import org.neo4j.jdbc.internal.shaded.jooq.Clause;
import org.neo4j.jdbc.internal.shaded.jooq.Configuration;
import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.Function3;
import org.neo4j.jdbc.internal.shaded.jooq.Record;
import org.neo4j.jdbc.internal.shaded.jooq.Table;
import org.neo4j.jdbc.internal.shaded.jooq.Truncate;
import org.neo4j.jdbc.internal.shaded.jooq.TruncateCascadeStep;
import org.neo4j.jdbc.internal.shaded.jooq.TruncateFinalStep;
import org.neo4j.jdbc.internal.shaded.jooq.TruncateIdentityStep;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractDDLQuery;
import org.neo4j.jdbc.internal.shaded.jooq.impl.DSL;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Keywords;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartList;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QueryPartListView;

final class TruncateImpl<R extends Record>
extends AbstractDDLQuery
implements QOM.Truncate<R>,
TruncateIdentityStep<R>,
TruncateCascadeStep<R>,
TruncateFinalStep<R>,
Truncate<R> {
    final QueryPartListView<? extends Table<?>> table;
    QOM.IdentityRestartOption restartIdentity;
    QOM.Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.TRUNCATE};

    TruncateImpl(Configuration configuration, Collection<? extends Table<?>> table) {
        this(configuration, table, null, null);
    }

    TruncateImpl(Configuration configuration, Collection<? extends Table<?>> table, QOM.IdentityRestartOption restartIdentity, QOM.Cascade cascade) {
        super(configuration);
        this.table = new QueryPartList((Iterable<Table<?>>)table);
        this.restartIdentity = restartIdentity;
        this.cascade = cascade;
    }

    @Override
    public final TruncateImpl<R> restartIdentity() {
        this.restartIdentity = QOM.IdentityRestartOption.RESTART_IDENTITY;
        return this;
    }

    @Override
    public final TruncateImpl<R> continueIdentity() {
        this.restartIdentity = QOM.IdentityRestartOption.CONTINUE_IDENTITY;
        return this;
    }

    @Override
    public final TruncateImpl<R> cascade() {
        this.cascade = QOM.Cascade.CASCADE;
        return this;
    }

    @Override
    public final TruncateImpl<R> restrict() {
        this.cascade = QOM.Cascade.RESTRICT;
        return this;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case FIREBIRD: 
            case IGNITE: 
            case SQLITE: {
                if (this.table.size() == 1) {
                    ctx.visit(DSL.delete((Table)this.table.get(0)));
                    break;
                }
                this.accept0(ctx);
                break;
            }
            default: {
                this.accept0(ctx);
            }
        }
    }

    final void accept0(Context<?> ctx) {
        ctx.start(Clause.TRUNCATE_TRUNCATE).visit(Keywords.K_TRUNCATE).sql(' ').visit(Keywords.K_TABLE).sql(' ').visit(this.table);
        if (this.restartIdentity != null) {
            ctx.formatSeparator().visit(this.restartIdentity.keyword);
        }
        if (this.cascade != null) {
            ctx.formatSeparator().visit(this.cascade == QOM.Cascade.CASCADE ? Keywords.K_CASCADE : Keywords.K_RESTRICT);
        }
        ctx.end(Clause.TRUNCATE_TRUNCATE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Table<?>> $table() {
        return QOM.unmodifiable(this.table);
    }

    @Override
    public final QOM.IdentityRestartOption $restartIdentity() {
        return this.restartIdentity;
    }

    @Override
    public final QOM.Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final QOM.Truncate<R> $table(Collection<? extends Table<?>> newValue) {
        return this.$constructor().apply(newValue, this.$restartIdentity(), this.$cascade());
    }

    @Override
    public final QOM.Truncate<R> $restartIdentity(QOM.IdentityRestartOption newValue) {
        return this.$constructor().apply(this.$table(), newValue, this.$cascade());
    }

    @Override
    public final QOM.Truncate<R> $cascade(QOM.Cascade newValue) {
        return this.$constructor().apply(this.$table(), this.$restartIdentity(), newValue);
    }

    public final Function3<? super Collection<? extends Table<?>>, ? super QOM.IdentityRestartOption, ? super QOM.Cascade, ? extends QOM.Truncate<R>> $constructor() {
        return (a1, a2, a3) -> new TruncateImpl<R>(this.configuration(), (Collection<Table<?>>)a1, (QOM.IdentityRestartOption)((Object)a2), (QOM.Cascade)((Object)a3));
    }
}

