/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.internal.shaded.jooq.impl;

import org.neo4j.jdbc.internal.shaded.jooq.Context;
import org.neo4j.jdbc.internal.shaded.jooq.DataType;
import org.neo4j.jdbc.internal.shaded.jooq.Field;
import org.neo4j.jdbc.internal.shaded.jooq.Function2;
import org.neo4j.jdbc.internal.shaded.jooq.impl.AbstractField;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Cast;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Names;
import org.neo4j.jdbc.internal.shaded.jooq.impl.QOM;
import org.neo4j.jdbc.internal.shaded.jooq.impl.SQLDataType;
import org.neo4j.jdbc.internal.shaded.jooq.impl.Tools;
import org.neo4j.jdbc.internal.shaded.jooq.tools.StringUtils;

final class TryCast<T>
extends AbstractField<T>
implements QOM.TryCast<T> {
    final Field<?> value;
    final DataType<T> dataType;

    TryCast(Field<?> value, DataType<T> dataType) {
        super(Names.N_TRY_CAST, dataType);
        this.value = Tools.nullSafeNotNull(value, SQLDataType.OTHER);
        this.dataType = dataType;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            default: 
        }
        ctx.visit(new Cast.CastNative<T>(this.value, this.dataType, true));
    }

    @Override
    public final Field<?> $arg1() {
        return this.value;
    }

    @Override
    public final DataType<T> $arg2() {
        return this.dataType;
    }

    @Override
    public final QOM.TryCast<T> $arg1(Field<?> newValue) {
        return this.$constructor().apply(newValue, (DataType<T>)this.$arg2());
    }

    @Override
    public final QOM.TryCast<T> $arg2(DataType<T> newValue) {
        return this.$constructor().apply((Field<?>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<?>, ? super DataType<T>, ? extends QOM.TryCast<T>> $constructor() {
        return (a1, a2) -> new TryCast((Field<?>)a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.TryCast) {
            QOM.TryCast o = (QOM.TryCast)that;
            return StringUtils.equals(this.$value(), o.$value()) && StringUtils.equals(this.$dataType(), o.$dataType());
        }
        return super.equals(that);
    }
}

