/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.values;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.neo4j.jdbc.values.AbstractValue;
import org.neo4j.jdbc.values.Type;
import org.neo4j.jdbc.values.Value;
import org.neo4j.jdbc.values.Values;

public final class MapValue
extends AbstractValue {
    private final Map<String, Value> val;

    MapValue(Map<String, Value> val) {
        this.val = Objects.requireNonNull(val, "Cannot construct MapValue from null");
    }

    @Override
    public boolean isEmpty() {
        return this.val.isEmpty();
    }

    @Override
    public Map<String, Object> asObject() {
        return this.asMap(Value::asObject);
    }

    @Override
    public Map<String, Object> asMap() {
        return MapValue.map(this.val, Value::asObject);
    }

    @Override
    public <T> Map<String, T> asMap(Function<Value, T> mapFunction) {
        return MapValue.map(this.val, mapFunction);
    }

    @Override
    public int size() {
        return this.val.size();
    }

    @Override
    public boolean containsKey(String key) {
        return this.val.containsKey(key);
    }

    @Override
    public Iterable<String> keys() {
        return this.val.keySet();
    }

    @Override
    public Iterable<Value> values() {
        return this.val.values();
    }

    @Override
    public <T> Iterable<T> values(Function<Value, T> mapFunction) {
        return MapValue.map(this.val, mapFunction).values();
    }

    @Override
    public Value get(String key) {
        Value value = this.val.get(key);
        return value != null ? value : Values.NULL;
    }

    @Override
    public Type type() {
        return Type.MAP;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapValue values = (MapValue)o;
        return this.val.equals(values.val);
    }

    @Override
    public int hashCode() {
        return this.val.hashCode();
    }

    @Override
    public String toString() {
        return MapValue.formatPairs(this.asMap(Values.ofValue()));
    }

    private static <T> Map<String, T> map(Map<String, Value> data, Function<Value, T> mapFunction) {
        if (data.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = data.size();
        if (size == 1) {
            Map.Entry<String, Value> head = data.entrySet().iterator().next();
            return Collections.singletonMap(head.getKey(), mapFunction.apply(head.getValue()));
        }
        LinkedHashMap<String, T> map = new LinkedHashMap<String, T>(size);
        for (Map.Entry<String, Value> entry : data.entrySet()) {
            map.put(entry.getKey(), mapFunction.apply(entry.getValue()));
        }
        return Collections.unmodifiableMap(map);
    }
}

