/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import org.apache.maven.plugin.logging.Log;
import org.jspecify.annotations.Nullable;
import org.openrewrite.maven.MavenLoggingMeterRegistry;

public class MeterRegistryProvider
implements AutoCloseable {
    private final Log log;
    private final @Nullable String destination;
    private @Nullable MeterRegistry registry;

    public MeterRegistryProvider(Log log, @Nullable String destination) {
        this.log = log;
        this.destination = destination;
    }

    public MeterRegistry registry() {
        if (this.registry == null) {
            this.registry = this.buildRegistry();
        }
        return this.registry;
    }

    private MeterRegistry buildRegistry() {
        if ("LOG".equals(this.destination)) {
            return new MavenLoggingMeterRegistry(this.log);
        }
        return new CompositeMeterRegistry();
    }

    @Override
    public void close() {
        if (this.registry != null) {
            this.registry.close();
        }
    }
}

