/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class AddScalarPreferStandardBasicTypes
extends Recipe {
    static final MethodMatcher ADD_SCALAR_MATCHER = new MethodMatcher("org.hibernate.query.NativeQuery addScalar(String, org.hibernate.type.Type)");
    private static final String STANDARD_BASIC_TYPES_FQN = "org.hibernate.type.StandardBasicTypes";
    private static final Map<String, String> CONVERTIBLE_TYPES = new HashMap<String, String>();

    public String getDisplayName() {
        return "AddScalarPreferStandardBasicTypesForHibernate5";
    }

    public String getDescription() {
        return "Prefer the use of `StandardBasicTypes.*` in `NativeQuery.addScalar(...)` invocations.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ADD_SCALAR_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!ADD_SCALAR_MATCHER.matches((MethodCall)m)) {
                    return m;
                }
                Expression firstArg = (Expression)m.getArguments().get(0);
                Expression secondArg = (Expression)m.getArguments().get(1);
                JavaType secondArgType = secondArg.getType();
                if (secondArgType == null || secondArg instanceof J.FieldAccess && TypeUtils.isOfClassType((JavaType)((J.FieldAccess)secondArg).getTarget().getType(), (String)AddScalarPreferStandardBasicTypes.STANDARD_BASIC_TYPES_FQN)) {
                    return m;
                }
                Optional<String> standardBasicTypesConstant = this.findConvertibleStandardBasicTypesConstant(secondArgType);
                if (standardBasicTypesConstant.isPresent()) {
                    this.maybeAddImport(AddScalarPreferStandardBasicTypes.STANDARD_BASIC_TYPES_FQN);
                    this.maybeRemoveImport(secondArgType.toString());
                    return (J.MethodInvocation)JavaTemplate.builder((String)"#{}, StandardBasicTypes.#{}").imports(new String[]{AddScalarPreferStandardBasicTypes.STANDARD_BASIC_TYPES_FQN}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"hibernate-core-6.+"})).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replaceArguments(), new Object[]{firstArg, standardBasicTypesConstant.get()});
                }
                return m;
            }

            private Optional<String> findConvertibleStandardBasicTypesConstant(JavaType type) {
                if (type instanceof JavaType.FullyQualified) {
                    String searchedFQN = ((JavaType.FullyQualified)type).getFullyQualifiedName();
                    for (Map.Entry entry : CONVERTIBLE_TYPES.entrySet()) {
                        if (!TypeUtils.fullyQualifiedNamesAreEqual((String)searchedFQN, (String)((String)entry.getKey()))) continue;
                        return Optional.of((String)CONVERTIBLE_TYPES.get(entry.getKey()));
                    }
                }
                return Optional.empty();
            }
        });
    }

    static {
        CONVERTIBLE_TYPES.put("org.hibernate.type.BigDecimalType", "BIG_DECIMAL");
        CONVERTIBLE_TYPES.put("org.hibernate.type.BigIntegerType", "BIG_INTEGER");
        CONVERTIBLE_TYPES.put("org.hibernate.type.BinaryType", "BINARY");
        CONVERTIBLE_TYPES.put("org.hibernate.type.BlobType", "BLOB");
        CONVERTIBLE_TYPES.put("org.hibernate.type.BooleanType", "BOOLEAN");
        CONVERTIBLE_TYPES.put("org.hibernate.type.ByteType", "BYTE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.CalendarDateType", "CALENDAR_DATE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.CalendarType", "CALENDAR");
        CONVERTIBLE_TYPES.put("org.hibernate.type.CharArrayType", "CHAR_ARRAY");
        CONVERTIBLE_TYPES.put("org.hibernate.type.CharacterArrayType", "CHARACTER_ARRAY");
        CONVERTIBLE_TYPES.put("org.hibernate.type.CharacterType", "CHARACTER");
        CONVERTIBLE_TYPES.put("org.hibernate.type.ClassType", "CLASS");
        CONVERTIBLE_TYPES.put("org.hibernate.type.ClobType", "CLOB");
        CONVERTIBLE_TYPES.put("org.hibernate.type.CurrencyType", "CURRENCY");
        CONVERTIBLE_TYPES.put("org.hibernate.type.DateType", "DATE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.DoubleType", "DOUBLE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.FloatType", "FLOAT");
        CONVERTIBLE_TYPES.put("org.hibernate.type.ImageType", "IMAGE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.IntegerType", "INTEGER");
        CONVERTIBLE_TYPES.put("org.hibernate.type.LocaleType", "LOCALE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.LongType", "LONG");
        CONVERTIBLE_TYPES.put("org.hibernate.type.MaterializedBlobType", "MATERIALIZED_BLOB");
        CONVERTIBLE_TYPES.put("org.hibernate.type.MaterializedClobType", "MATERIALIZED_CLOB");
        CONVERTIBLE_TYPES.put("org.hibernate.type.MaterializedNClobType", "MATERIALIZED_NCLOB");
        CONVERTIBLE_TYPES.put("org.hibernate.type.NClobType", "NCLOB");
        CONVERTIBLE_TYPES.put("org.hibernate.type.NTextType", "NTEXT");
        CONVERTIBLE_TYPES.put("org.hibernate.type.NumericBooleanType", "NUMERIC_BOOLEAN");
        CONVERTIBLE_TYPES.put("org.hibernate.type.RowVersionType", "ROW_VERSION");
        CONVERTIBLE_TYPES.put("org.hibernate.type.SerializableType", "SERIALIZABLE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.ShortType", "SHORT");
        CONVERTIBLE_TYPES.put("org.hibernate.type.StringNVarcharType", "NSTRING");
        CONVERTIBLE_TYPES.put("org.hibernate.type.StringType", "STRING");
        CONVERTIBLE_TYPES.put("org.hibernate.type.TextType", "TEXT");
        CONVERTIBLE_TYPES.put("org.hibernate.type.TimeType", "TIME");
        CONVERTIBLE_TYPES.put("org.hibernate.type.TimeZoneType", "TIMEZONE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.TimestampType", "TIMESTAMP");
        CONVERTIBLE_TYPES.put("org.hibernate.type.TrueFalseType", "TRUE_FALSE");
        CONVERTIBLE_TYPES.put("org.hibernate.type.UUIDBinaryType", "UUID_BINARY");
        CONVERTIBLE_TYPES.put("org.hibernate.type.UUIDCharType", "UUID_CHAR");
        CONVERTIBLE_TYPES.put("org.hibernate.type.UrlType", "URL");
        CONVERTIBLE_TYPES.put("org.hibernate.type.WrapperBinaryType", "WRAPPER_BINARY");
        CONVERTIBLE_TYPES.put("org.hibernate.type.YesNoType", "YES_NO");
    }
}

