/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;
import org.openrewrite.shaded.jgit.annotations.Nullable;
import org.openrewrite.shaded.jgit.lib.Ref;
import org.openrewrite.shaded.jgit.lib.RefComparator;

public class RefList<T extends Ref>
implements Iterable<Ref> {
    private static final RefList<Ref> EMPTY = new RefList(new Ref[0], 0);
    final Ref[] list;
    final int cnt;

    public static <T extends Ref> RefList<T> emptyList() {
        return EMPTY;
    }

    RefList(Ref[] list, int cnt) {
        this.list = list;
        this.cnt = cnt;
    }

    protected RefList(RefList<T> src) {
        this.list = src.list;
        this.cnt = src.cnt;
    }

    @Override
    public Iterator<Ref> iterator() {
        return new Iterator<Ref>(){
            private int idx;

            @Override
            public boolean hasNext() {
                return this.idx < RefList.this.cnt;
            }

            @Override
            public Ref next() {
                if (this.idx < RefList.this.cnt) {
                    return RefList.this.list[this.idx++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public final List<Ref> asList() {
        List<Ref> r = Arrays.asList(this.list).subList(0, this.cnt);
        return Collections.unmodifiableList(r);
    }

    public final int size() {
        return this.cnt;
    }

    public final boolean isEmpty() {
        return this.cnt == 0;
    }

    public final int find(String name) {
        int high = this.cnt;
        if (high == 0) {
            return -1;
        }
        int low = 0;
        do {
            int mid;
            int cmp;
            if ((cmp = RefComparator.compareTo(this.list[mid = low + high >>> 1], name)) < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            high = mid;
        } while (low < high);
        return -(low + 1);
    }

    public final boolean contains(String name) {
        return this.find(name) >= 0;
    }

    public final T get(String name) {
        int idx = this.find(name);
        return idx >= 0 ? (T)this.get(idx) : null;
    }

    public final T get(int idx) {
        return (T)this.list[idx];
    }

    public final Builder<T> copy(int n) {
        Builder r = new Builder(Math.max(16, n));
        r.addAll(this.list, 0, n);
        return r;
    }

    public final RefList<T> set(int idx, T ref) {
        Ref[] newList = new Ref[this.cnt];
        System.arraycopy(this.list, 0, newList, 0, this.cnt);
        newList[idx] = ref;
        return new RefList<T>(newList, this.cnt);
    }

    public final RefList<T> add(int idx, T ref) {
        if (idx < 0) {
            idx = -(idx + 1);
        }
        Ref[] newList = new Ref[this.cnt + 1];
        if (idx > 0) {
            System.arraycopy(this.list, 0, newList, 0, idx);
        }
        newList[idx] = ref;
        if (idx < this.cnt) {
            System.arraycopy(this.list, idx, newList, idx + 1, this.cnt - idx);
        }
        return new RefList<T>(newList, this.cnt + 1);
    }

    public final RefList<T> remove(int idx) {
        if (this.cnt == 1) {
            return RefList.emptyList();
        }
        Ref[] newList = new Ref[this.cnt - 1];
        if (idx > 0) {
            System.arraycopy(this.list, 0, newList, 0, idx);
        }
        if (idx + 1 < this.cnt) {
            System.arraycopy(this.list, idx + 1, newList, idx, this.cnt - (idx + 1));
        }
        return new RefList<T>(newList, this.cnt - 1);
    }

    public final RefList<T> put(T ref) {
        int idx = this.find(ref.getName());
        if (idx >= 0) {
            return this.set(idx, ref);
        }
        return this.add(idx, ref);
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append('[');
        if (this.cnt > 0) {
            r.append(this.list[0]);
            int i = 1;
            while (i < this.cnt) {
                r.append(", ");
                r.append(this.list[i]);
                ++i;
            }
        }
        r.append(']');
        return r.toString();
    }

    public static <T extends Ref> Collector<T, ?, RefList<T>> toRefList(@Nullable BinaryOperator<T> mergeFunction) {
        return Collector.of(() -> new Builder(), Builder::add, (b1, b2) -> {
            Builder b = new Builder();
            b.addAll((Builder)b1);
            b.addAll((Builder)b2);
            return b;
        }, b -> {
            if (mergeFunction != null) {
                b.sort();
                b.dedupe(mergeFunction);
            }
            return b.toRefList();
        }, new Collector.Characteristics[0]);
    }

    public static class Builder<T extends Ref> {
        private Ref[] list;
        private int size;

        public Builder() {
            this(16);
        }

        public Builder(int capacity) {
            this.list = new Ref[Math.max(capacity, 16)];
        }

        public int size() {
            return this.size;
        }

        public T get(int idx) {
            return (T)this.list[idx];
        }

        public void remove(int idx) {
            System.arraycopy(this.list, idx + 1, this.list, idx, this.size - (idx + 1));
            --this.size;
        }

        public void add(T ref) {
            if (this.list.length == this.size) {
                Ref[] n = new Ref[this.size * 2];
                System.arraycopy(this.list, 0, n, 0, this.size);
                this.list = n;
            }
            this.list[this.size++] = ref;
        }

        public void addAll(Builder other) {
            this.addAll(other.list, 0, other.size);
        }

        public void addAll(Ref[] src, int off, int cnt) {
            if (this.list.length < this.size + cnt) {
                Ref[] n = new Ref[Math.max(this.size * 2, this.size + cnt)];
                System.arraycopy(this.list, 0, n, 0, this.size);
                this.list = n;
            }
            System.arraycopy(src, off, this.list, this.size, cnt);
            this.size += cnt;
        }

        public void set(int idx, T ref) {
            this.list[idx] = ref;
        }

        public void sort() {
            Arrays.sort(this.list, 0, this.size, RefComparator.INSTANCE);
        }

        void dedupe(BinaryOperator<T> mergeFunction) {
            if (this.size == 0) {
                return;
            }
            int lastElement = 0;
            int i = 1;
            while (i < this.size) {
                if (RefComparator.INSTANCE.compare(this.list[lastElement], this.list[i]) == 0) {
                    this.list[lastElement] = (Ref)mergeFunction.apply(this.list[lastElement], this.list[i]);
                } else {
                    this.list[lastElement + 1] = this.list[i];
                    ++lastElement;
                }
                ++i;
            }
            this.size = lastElement + 1;
            Arrays.fill(this.list, this.size, this.list.length, null);
        }

        public RefList<T> toRefList() {
            return new RefList(this.list, this.size);
        }

        public String toString() {
            return this.toRefList().toString();
        }
    }
}

