/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class RecipeRunStats
extends DataTable<Row> {
    private final MeterRegistry registry = new SimpleMeterRegistry();
    private final Set<Path> sourceFileChanged = new HashSet<Path>();

    public RecipeRunStats(Recipe recipe) {
        super(recipe, "Recipe performance", "Statistics used in analyzing the performance of recipes.");
    }

    public void recordSourceFileChanged(@Nullable SourceFile before, @Nullable SourceFile after) {
        if (after != null) {
            this.sourceFileChanged.add(after.getSourcePath());
        } else if (before != null) {
            this.sourceFileChanged.add(before.getSourcePath());
        }
    }

    public void recordScan(Recipe recipe, Callable<SourceFile> scan) throws Exception {
        Timer.builder((String)"rewrite.recipe.scan").tag("name", recipe.getName()).publishPercentiles(new double[]{0.99}).register(this.registry).recordCallable(scan);
    }

    @Nullable
    public SourceFile recordEdit(Recipe recipe, Callable<SourceFile> edit) throws Exception {
        return (SourceFile)Timer.builder((String)"rewrite.recipe.edit").tag("name", recipe.getName()).publishPercentiles(new double[]{0.99}).register(this.registry).recordCallable(edit);
    }

    public void flush(ExecutionContext ctx) {
        for (Timer editor : this.registry.find("rewrite.recipe.edit").timers()) {
            String recipeName = Objects.requireNonNull(editor.getId().getTag("name"));
            Timer scanner = this.registry.find("rewrite.recipe.scan").tag("name", recipeName).timer();
            Row row = new Row(recipeName, Long.valueOf(editor.count()).intValue(), this.sourceFileChanged.size(), scanner == null ? 0L : (long)scanner.totalTime(TimeUnit.NANOSECONDS), scanner == null ? 0.0 : scanner.takeSnapshot().percentileValues()[0].percentile(), scanner == null ? 0L : (long)scanner.max(TimeUnit.NANOSECONDS), (long)editor.totalTime(TimeUnit.NANOSECONDS), editor.takeSnapshot().percentileValues()[0].percentile(), (long)editor.max(TimeUnit.NANOSECONDS));
            ctx.computeMessage("org.openrewrite.dataTables", row, ConcurrentHashMap::new, (extract, allDataTables) -> {
                List dataTablesOfType = (List)allDataTables.computeIfAbsent(this, c -> new ArrayList());
                dataTablesOfType.add(row);
                return allDataTables;
            });
        }
    }

    public static final class Row {
        @Column(displayName="The recipe", description="The recipe whose stats are being measured both individually and cumulatively.")
        private final String recipe;
        @Column(displayName="Source file count", description="The number of source files the recipe ran over.")
        private final Integer sourceFiles;
        @Column(displayName="Source file changed count", description="The number of source files which were changed in the recipe run. Includes files created, deleted, and edited.")
        private final Integer sourceFilesChanged;
        @Column(displayName="Cumulative scanning time", description="The total time spent across the scanning phase of this recipe.")
        private final Long scanTotalTime;
        @Column(displayName="99th percentile scanning time", description="99 out of 100 scans completed in this amount of time.")
        private final Double scanP99;
        @Column(displayName="Max scanning time", description="The max time scanning any one source file.")
        private final Long scanMax;
        @Column(displayName="Cumulative edit time", description="The total time spent across the editing phase of this recipe.")
        private final Long editTotalTime;
        @Column(displayName="99th percentile edit time", description="99 out of 100 edits completed in this amount of time.")
        private final Double editP99;
        @Column(displayName="Max edit time", description="The max time editing any one source file.")
        private final Long editMax;

        public Row(String recipe, Integer sourceFiles, Integer sourceFilesChanged, Long scanTotalTime, Double scanP99, Long scanMax, Long editTotalTime, Double editP99, Long editMax) {
            this.recipe = recipe;
            this.sourceFiles = sourceFiles;
            this.sourceFilesChanged = sourceFilesChanged;
            this.scanTotalTime = scanTotalTime;
            this.scanP99 = scanP99;
            this.scanMax = scanMax;
            this.editTotalTime = editTotalTime;
            this.editP99 = editP99;
            this.editMax = editMax;
        }

        public String getRecipe() {
            return this.recipe;
        }

        public Integer getSourceFiles() {
            return this.sourceFiles;
        }

        public Integer getSourceFilesChanged() {
            return this.sourceFilesChanged;
        }

        public Long getScanTotalTime() {
            return this.scanTotalTime;
        }

        public Double getScanP99() {
            return this.scanP99;
        }

        public Long getScanMax() {
            return this.scanMax;
        }

        public Long getEditTotalTime() {
            return this.editTotalTime;
        }

        public Double getEditP99() {
            return this.editP99;
        }

        public Long getEditMax() {
            return this.editMax;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$sourceFiles = this.getSourceFiles();
            Integer other$sourceFiles = other.getSourceFiles();
            if (this$sourceFiles == null ? other$sourceFiles != null : !((Object)this$sourceFiles).equals(other$sourceFiles)) {
                return false;
            }
            Integer this$sourceFilesChanged = this.getSourceFilesChanged();
            Integer other$sourceFilesChanged = other.getSourceFilesChanged();
            if (this$sourceFilesChanged == null ? other$sourceFilesChanged != null : !((Object)this$sourceFilesChanged).equals(other$sourceFilesChanged)) {
                return false;
            }
            Long this$scanTotalTime = this.getScanTotalTime();
            Long other$scanTotalTime = other.getScanTotalTime();
            if (this$scanTotalTime == null ? other$scanTotalTime != null : !((Object)this$scanTotalTime).equals(other$scanTotalTime)) {
                return false;
            }
            Double this$scanP99 = this.getScanP99();
            Double other$scanP99 = other.getScanP99();
            if (this$scanP99 == null ? other$scanP99 != null : !((Object)this$scanP99).equals(other$scanP99)) {
                return false;
            }
            Long this$scanMax = this.getScanMax();
            Long other$scanMax = other.getScanMax();
            if (this$scanMax == null ? other$scanMax != null : !((Object)this$scanMax).equals(other$scanMax)) {
                return false;
            }
            Long this$editTotalTime = this.getEditTotalTime();
            Long other$editTotalTime = other.getEditTotalTime();
            if (this$editTotalTime == null ? other$editTotalTime != null : !((Object)this$editTotalTime).equals(other$editTotalTime)) {
                return false;
            }
            Double this$editP99 = this.getEditP99();
            Double other$editP99 = other.getEditP99();
            if (this$editP99 == null ? other$editP99 != null : !((Object)this$editP99).equals(other$editP99)) {
                return false;
            }
            Long this$editMax = this.getEditMax();
            Long other$editMax = other.getEditMax();
            if (this$editMax == null ? other$editMax != null : !((Object)this$editMax).equals(other$editMax)) {
                return false;
            }
            String this$recipe = this.getRecipe();
            String other$recipe = other.getRecipe();
            return !(this$recipe == null ? other$recipe != null : !this$recipe.equals(other$recipe));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $sourceFiles = this.getSourceFiles();
            result = result * 59 + ($sourceFiles == null ? 43 : ((Object)$sourceFiles).hashCode());
            Integer $sourceFilesChanged = this.getSourceFilesChanged();
            result = result * 59 + ($sourceFilesChanged == null ? 43 : ((Object)$sourceFilesChanged).hashCode());
            Long $scanTotalTime = this.getScanTotalTime();
            result = result * 59 + ($scanTotalTime == null ? 43 : ((Object)$scanTotalTime).hashCode());
            Double $scanP99 = this.getScanP99();
            result = result * 59 + ($scanP99 == null ? 43 : ((Object)$scanP99).hashCode());
            Long $scanMax = this.getScanMax();
            result = result * 59 + ($scanMax == null ? 43 : ((Object)$scanMax).hashCode());
            Long $editTotalTime = this.getEditTotalTime();
            result = result * 59 + ($editTotalTime == null ? 43 : ((Object)$editTotalTime).hashCode());
            Double $editP99 = this.getEditP99();
            result = result * 59 + ($editP99 == null ? 43 : ((Object)$editP99).hashCode());
            Long $editMax = this.getEditMax();
            result = result * 59 + ($editMax == null ? 43 : ((Object)$editMax).hashCode());
            String $recipe = this.getRecipe();
            result = result * 59 + ($recipe == null ? 43 : $recipe.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "RecipeRunStats.Row(recipe=" + this.getRecipe() + ", sourceFiles=" + this.getSourceFiles() + ", sourceFilesChanged=" + this.getSourceFilesChanged() + ", scanTotalTime=" + this.getScanTotalTime() + ", scanP99=" + this.getScanP99() + ", scanMax=" + this.getScanMax() + ", editTotalTime=" + this.getEditTotalTime() + ", editP99=" + this.getEditP99() + ", editMax=" + this.getEditMax() + ")";
        }
    }
}

