/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.OrderImports;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeTree;

public final class UpdateMovedPackageClassName
extends Recipe {
    @Option(displayName="The fully qualified className moved from", description="The fully qualified className moved from a old package.", example="org.openrewrite.java.cleanup.UnnecessaryCatch")
    private final String fullyQualifiedClassNameMovedFrom;
    @Option(displayName="The fully qualified className moved to", description="The fully qualified className moved to a new package.", example="org.openrewrite.staticanalysis.UnnecessaryCatch")
    private final String fullyQualifiedClassNameMovedTo;

    public String getDisplayName() {
        return "Update moved package class name";
    }

    public String getDescription() {
        return "When a class moved from package A to B, update the fully qualified className accordingly.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                if (fieldAccess.toString().equals(UpdateMovedPackageClassName.this.fullyQualifiedClassNameMovedFrom)) {
                    return (J.FieldAccess)TypeTree.build(UpdateMovedPackageClassName.this.fullyQualifiedClassNameMovedTo).withPrefix(fieldAccess.getPrefix());
                }
                return super.visitFieldAccess(fieldAccess, ctx);
            }

            @Override
            public J.Import visitImport(J.Import _import, ExecutionContext ctx) {
                J after = super.visitImport(_import, ctx);
                if (_import != after) {
                    this.maybeRemoveImport(UpdateMovedPackageClassName.this.fullyQualifiedClassNameMovedFrom);
                    this.maybeAddImport(UpdateMovedPackageClassName.this.fullyQualifiedClassNameMovedTo);
                    this.doAfterVisit(new OrderImports(true).getVisitor());
                }
                return after;
            }
        };
    }

    public UpdateMovedPackageClassName(String fullyQualifiedClassNameMovedFrom, String fullyQualifiedClassNameMovedTo) {
        this.fullyQualifiedClassNameMovedFrom = fullyQualifiedClassNameMovedFrom;
        this.fullyQualifiedClassNameMovedTo = fullyQualifiedClassNameMovedTo;
    }

    public String getFullyQualifiedClassNameMovedFrom() {
        return this.fullyQualifiedClassNameMovedFrom;
    }

    public String getFullyQualifiedClassNameMovedTo() {
        return this.fullyQualifiedClassNameMovedTo;
    }

    @NonNull
    public String toString() {
        return "UpdateMovedPackageClassName(fullyQualifiedClassNameMovedFrom=" + this.getFullyQualifiedClassNameMovedFrom() + ", fullyQualifiedClassNameMovedTo=" + this.getFullyQualifiedClassNameMovedTo() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateMovedPackageClassName)) {
            return false;
        }
        UpdateMovedPackageClassName other = (UpdateMovedPackageClassName)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$fullyQualifiedClassNameMovedFrom = this.getFullyQualifiedClassNameMovedFrom();
        String other$fullyQualifiedClassNameMovedFrom = other.getFullyQualifiedClassNameMovedFrom();
        if (this$fullyQualifiedClassNameMovedFrom == null ? other$fullyQualifiedClassNameMovedFrom != null : !this$fullyQualifiedClassNameMovedFrom.equals(other$fullyQualifiedClassNameMovedFrom)) {
            return false;
        }
        String this$fullyQualifiedClassNameMovedTo = this.getFullyQualifiedClassNameMovedTo();
        String other$fullyQualifiedClassNameMovedTo = other.getFullyQualifiedClassNameMovedTo();
        return !(this$fullyQualifiedClassNameMovedTo == null ? other$fullyQualifiedClassNameMovedTo != null : !this$fullyQualifiedClassNameMovedTo.equals(other$fullyQualifiedClassNameMovedTo));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpdateMovedPackageClassName;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fullyQualifiedClassNameMovedFrom = this.getFullyQualifiedClassNameMovedFrom();
        result = result * 59 + ($fullyQualifiedClassNameMovedFrom == null ? 43 : $fullyQualifiedClassNameMovedFrom.hashCode());
        String $fullyQualifiedClassNameMovedTo = this.getFullyQualifiedClassNameMovedTo();
        result = result * 59 + ($fullyQualifiedClassNameMovedTo == null ? 43 : $fullyQualifiedClassNameMovedTo.hashCode());
        return result;
    }
}

