/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public final class FindFieldsOfType
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified Java type name, that is used to find matching fields.", example="org.slf4j.api.Logger")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    @Nullable
    private final Boolean matchInherited;

    public String getDisplayName() {
        return "Find fields of type";
    }

    public String getDescription() {
        return "Finds declared fields matching a particular class name.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (multiVariable.getTypeExpression() instanceof J.MultiCatch) {
                    return multiVariable;
                }
                if (multiVariable.getTypeExpression() != null && FindFieldsOfType.hasElementType(multiVariable.getTypeExpression().getType(), FindFieldsOfType.this.fullyQualifiedTypeName, Boolean.TRUE.equals(FindFieldsOfType.this.matchInherited)) && FindFieldsOfType.isField(this.getCursor())) {
                    return (J.VariableDeclarations)SearchResult.found((Tree)multiVariable);
                }
                return multiVariable;
            }
        };
    }

    public static Set<J.VariableDeclarations> find(J j, final String fullyQualifiedTypeName) {
        JavaIsoVisitor<Set<J.VariableDeclarations>> findVisitor = new JavaIsoVisitor<Set<J.VariableDeclarations>>(){

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, Set<J.VariableDeclarations> vs) {
                if (multiVariable.getTypeExpression() instanceof J.MultiCatch) {
                    return multiVariable;
                }
                if (multiVariable.getTypeExpression() != null && FindFieldsOfType.hasElementType(multiVariable.getTypeExpression().getType(), fullyQualifiedTypeName, true) && FindFieldsOfType.isField(this.getCursor())) {
                    vs.add(multiVariable);
                }
                return multiVariable;
            }
        };
        HashSet<J.VariableDeclarations> vs = new HashSet<J.VariableDeclarations>();
        findVisitor.visit(j, vs);
        return vs;
    }

    private static boolean isField(Cursor cursor) {
        Iterator path = cursor.getPath();
        while (path.hasNext()) {
            Object o = path.next();
            if (o instanceof J.MethodDeclaration) {
                return false;
            }
            if (!(o instanceof J.ClassDeclaration)) continue;
            return true;
        }
        return true;
    }

    private static boolean hasElementType(@Nullable JavaType type, String fullyQualifiedName, boolean matchOverrides) {
        if (type instanceof JavaType.Array) {
            return FindFieldsOfType.hasElementType(((JavaType.Array)type).getElemType(), fullyQualifiedName, matchOverrides);
        }
        if (type instanceof JavaType.FullyQualified) {
            return new TypeMatcher(fullyQualifiedName, matchOverrides).matches(type);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable generic = (JavaType.GenericTypeVariable)type;
            for (JavaType bound : generic.getBounds()) {
                if (!FindFieldsOfType.hasElementType(bound, fullyQualifiedName, matchOverrides)) continue;
                return true;
            }
        }
        return false;
    }

    public FindFieldsOfType(String fullyQualifiedTypeName, @Nullable Boolean matchInherited) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.matchInherited = matchInherited;
    }

    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Nullable
    public Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @NonNull
    public String toString() {
        return "FindFieldsOfType(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", matchInherited=" + this.getMatchInherited() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFieldsOfType)) {
            return false;
        }
        FindFieldsOfType other = (FindFieldsOfType)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        return !(this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindFieldsOfType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        return result;
    }
}

