/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.kotlin.cleanup;

import java.time.Duration;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.kotlin.KotlinVisitor;

public class UnnecessaryTypeParentheses
extends Recipe {
    public String getDisplayName() {
        return "Remove unnecessary parentheses on Kotlin types";
    }

    public String getDescription() {
        return "In Kotlin, it's possible to add redundant nested parentheses in type definitions. This recipe is designed to remove those unnecessary parentheses.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(3L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new KotlinVisitor<ExecutionContext>(){

            public J visitParenthesizedTypeTree(J.ParenthesizedTypeTree parTree, ExecutionContext ctx) {
                Space prefix = parTree.getPrefix();
                J.ParenthesizedTypeTree tt = parTree;
                while (tt instanceof J.ParenthesizedTypeTree) {
                    tt = (TypeTree)tt.getParenthesizedType().getTree();
                }
                return tt.withPrefix(prefix);
            }
        };
    }
}

