/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.IdentityHashMap;
import java.util.Map;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.uni.ForEachUniNode;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;

final class BavetConstraintSession<Score_ extends Score<Score_>> {
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final Map<Class<?>, ForEachUniNode<Object>> declaredClassToNodeMap;
    private final AbstractNode[] nodes;
    private final Map<Class<?>, ForEachUniNode<Object>[]> effectiveClassToNodeArrayMap;

    public BavetConstraintSession(AbstractScoreInliner<Score_> scoreInliner, Map<Class<?>, ForEachUniNode<Object>> declaredClassToNodeMap, AbstractNode[] nodes) {
        this.scoreInliner = scoreInliner;
        this.declaredClassToNodeMap = declaredClassToNodeMap;
        this.nodes = nodes;
        this.effectiveClassToNodeArrayMap = new IdentityHashMap(declaredClassToNodeMap.size());
    }

    public void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        for (ForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.insert(fact);
        }
    }

    private ForEachUniNode<Object>[] findNodes(Class<?> factClass) {
        ForEachUniNode<Object>[] nodeArray = this.effectiveClassToNodeArrayMap.get(factClass);
        if (nodeArray == null) {
            nodeArray = (ForEachUniNode[])this.declaredClassToNodeMap.entrySet().stream().filter(entry -> ((Class)entry.getKey()).isAssignableFrom(factClass)).map(Map.Entry::getValue).toArray(ForEachUniNode[]::new);
            this.effectiveClassToNodeArrayMap.put(factClass, nodeArray);
        }
        return nodeArray;
    }

    public void update(Object fact) {
        Class<?> factClass = fact.getClass();
        for (ForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.update(fact);
        }
    }

    public void retract(Object fact) {
        Class<?> factClass = fact.getClass();
        for (ForEachUniNode<Object> node : this.findNodes(factClass)) {
            node.retract(fact);
        }
    }

    public Score_ calculateScore(int initScore) {
        for (AbstractNode node : this.nodes) {
            node.calculateScore();
        }
        return (Score_)this.scoreInliner.extractScore(initScore);
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.scoreInliner.getConstraintMatchTotalMap();
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.scoreInliner.getIndictmentMap();
    }
}

