/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.ant.tasks;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.ow2.bonita.facade.Context;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class BonitaJava
extends Java {
    private String loginmode;
    private String apitype;
    private File jaas;
    private File env;
    private File log;
    private File bar;

    public void execute() {
        Environment.Variable var;
        if (this.bar == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bat_BJ_1", new Object[0]);
            throw new BuildException(message);
        }
        CommandlineJava java = this.getCommandLine();
        java.createArgument().setValue("-bar=" + this.bar.getAbsolutePath());
        Environment.Variable testVar = new Environment.Variable();
        testVar.setKey("login.mode");
        testVar.setValue(this.loginmode);
        java.addSysproperty(testVar);
        if (this.env != null) {
            var = new Environment.Variable();
            var.setKey("org.ow2.bonita.environment");
            var.setValue(this.env.getAbsolutePath());
            java.addSysproperty(var);
        }
        if (this.jaas != null) {
            var = new Environment.Variable();
            var.setKey("java.security.auth.login.config");
            var.setValue(this.jaas.getAbsolutePath());
            java.addSysproperty(var);
        }
        if (this.log != null) {
            var = new Environment.Variable();
            var.setKey("java.util.logging.config.file");
            var.setValue(this.log.getAbsolutePath());
            java.addSysproperty(var);
        }
        if (this.apitype != null) {
            var = new Environment.Variable();
            var.setKey("org.ow2.bonita.api-type");
            var.setValue(Misc.stringToEnum(Context.class, this.apitype).toString());
            java.addSysproperty(var);
        }
        try {
            super.execute();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.log(Misc.getStackTraceFrom(t), 0);
        }
    }

    public void setJaas(File jaas) {
        this.jaas = jaas;
    }

    public void setEnv(File env) {
        this.env = env;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public void setApitype(String apitype) {
        this.apitype = apitype;
    }

    public void setLoginmode(String loginmode) {
        this.loginmode = loginmode;
    }

    public void setBar(File bar) {
        this.bar = bar;
    }
}

