/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.ant.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.util.BusinessArchiveFactory;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.Misc;

public class GenerateBar
extends Task {
    private static final Logger LOG = Logger.getLogger(GenerateBar.class.getName());
    protected File destfile = null;
    protected Collection<FileSet> fileSets = new ArrayList<FileSet>();

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void addFileset(FileSet fileSet) {
        this.fileSets.add(fileSet);
    }

    public void execute() {
        if (this.destfile == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bat_GB_1", ((Object)((Object)this)).getClass().getName());
            throw new BuildException(message);
        }
        try {
            if (!this.destfile.exists()) {
                this.destfile.createNewFile();
            }
            HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
            for (FileSet fileSet : this.fileSets) {
                String[] files;
                DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
                for (String file : files = directoryScanner.getIncludedFiles()) {
                    File f = new File(directoryScanner.getBasedir().getAbsolutePath() + File.separatorChar + file);
                    if (!f.exists()) {
                        LOG.severe("File : " + f + " does not exist. Can't add it to the BAR.");
                        continue;
                    }
                    resources.put(file, Misc.getAllContentFrom(f));
                }
            }
            if (resources.isEmpty()) {
                String message = ExceptionManager.getInstance().getFullMessage("bat_GB_2", ((Object)((Object)this)).getClass().getName());
                throw new BuildException(message);
            }
            BusinessArchive businessArchive = BusinessArchiveFactory.getBusinessArchive(resources);
            BusinessArchiveFactory.generateBusinessArchiveFile(this.destfile, businessArchive);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

