/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.ow2.bonita.connector.core.ConnectorDescriptorAPI;
import org.ow2.bonita.connector.core.ConnectorError;
import org.ow2.bonita.connector.core.ConnectorValidator;
import org.ow2.bonita.connector.core.desc.ConnectorDescriptor;
import org.ow2.bonita.connector.core.desc.Getter;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.definition.TxHook;
import org.ow2.bonita.expression.ExpressionEvaluator;
import org.ow2.bonita.facade.APIAccessor;
import org.ow2.bonita.facade.runtime.ActivityInstance;

public abstract class Connector
implements TxHook {
    static final Logger LOG = Logger.getLogger(Connector.class.getName());
    public boolean validation = true;

    public static List<ConnectorError> validateConnector(Class<? extends Connector> c) {
        List<ConnectorError> errors = Connector.checkRuntimeAnnotations(c);
        errors.addAll(Connector.checkGraphicalAnnotations(c));
        return errors;
    }

    protected static List<ConnectorError> checkGraphicalAnnotations(Class<? extends Connector> c) {
        return ConnectorValidator.validateView(c);
    }

    protected static List<ConnectorError> checkRuntimeAnnotations(Class<? extends Connector> c) {
        return ConnectorValidator.validateRuntime(c);
    }

    protected static boolean isFieldExist(Class<? extends Connector> c, String fieldName) {
        if (fieldName == null || "".equals(fieldName.trim())) {
            return false;
        }
        Field field = Connector.getField(c, fieldName);
        boolean exist = false;
        if (field != null) {
            exist = true;
        }
        return exist;
    }

    private boolean isFieldSet(String fieldName) {
        Field field = Connector.getField(this.getClass(), fieldName);
        Object value = this.getFieldValue(field);
        boolean set = true;
        if (value == null) {
            set = false;
        }
        return set;
    }

    public static boolean fieldExists(Class<? extends Connector> c, String fieldName) {
        Field field = Connector.searchField(c, fieldName);
        boolean exists = true;
        if (field == null) {
            exists = false;
        }
        return exists;
    }

    protected static Field getField(Class<? extends Connector> c, String fieldName) {
        Field field = Connector.searchField(c, fieldName);
        if (field == null) {
            String upper = Connector.getFirstUpperCaseLetterFieldName(fieldName);
            field = Connector.searchField(c, upper);
        }
        return field;
    }

    private static Field searchField(Class<?> c, String fieldName) {
        Field field = null;
        if (c != null) {
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length && field == null; ++i) {
                if (!fields[i].getName().equals(fieldName)) continue;
                field = fields[i];
            }
            if (field == null) {
                return Connector.searchField(c.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static String getFieldName(String methodName) {
        int cut = 4;
        if (methodName.startsWith("is")) {
            cut = 3;
        }
        if (methodName.length() < cut) {
            return "";
        }
        String end = methodName.substring(cut);
        char c = methodName.charAt(cut - 1);
        String begin = String.valueOf(c).toLowerCase();
        return begin.concat(end);
    }

    public static String getGetterName(String fieldName) {
        StringBuilder builder = new StringBuilder("get");
        builder.append(String.valueOf(fieldName.charAt(0)).toUpperCase());
        builder.append(fieldName.substring(1));
        return builder.toString();
    }

    private static String getFirstUpperCaseLetterFieldName(String fieldName) {
        String end = fieldName.substring(1);
        char c = fieldName.charAt(0);
        String begin = String.valueOf(c).toUpperCase();
        return begin.concat(end);
    }

    public final void execute() throws Exception {
        List<ConnectorError> errors = this.validate();
        if (!errors.isEmpty()) {
            StringBuilder misconfigurationBuilder = new StringBuilder();
            for (ConnectorError error : errors) {
                misconfigurationBuilder.append(error.getField()).append(": ");
                Exception exception = error.getError();
                if (exception != null) {
                    misconfigurationBuilder.append(exception.getMessage());
                } else {
                    misconfigurationBuilder.append("unknown error");
                }
                misconfigurationBuilder.append("\n");
            }
            throw new IllegalStateException("The connector " + this.getClass().getName() + " cannot be executed due to a misconfiguration: " + misconfigurationBuilder.toString());
        }
        this.executeConnector();
    }

    protected abstract void executeConnector() throws Exception;

    protected abstract List<ConnectorError> validateValues();

    public final List<ConnectorError> validate() {
        ArrayList<ConnectorError> errors = new ArrayList<ConnectorError>();
        ConnectorDescriptor descriptor = ConnectorDescriptorAPI.load(this.getClass());
        if (descriptor != null) {
            List<ConnectorError> errorValues;
            List<Setter> inputs = descriptor.getInputs();
            if (inputs != null) {
                for (Setter input : inputs) {
                    boolean forbidden;
                    boolean required;
                    ConnectorError error = null;
                    String fieldName = Connector.getFieldName(input.getSetterName());
                    boolean set = this.isFieldSet(fieldName);
                    String requiredExpression = input.getRequired();
                    String forbiddenExpression = input.getForbidden();
                    if (requiredExpression != null && (required = this.getResultExpression(requiredExpression)) && !set) {
                        error = new ConnectorError(fieldName, new IllegalArgumentException("This field is required so it must be set."));
                        errors.add(error);
                    }
                    if (forbiddenExpression == null || !(forbidden = this.getResultExpression(forbiddenExpression)) || !set) continue;
                    error = new ConnectorError(fieldName, new IllegalArgumentException("This field cannot be set because of other field values."));
                    errors.add(error);
                }
            }
            if (errors.isEmpty() && (errorValues = this.validateValues()) != null) {
                errors.addAll(errorValues);
            }
        }
        return errors;
    }

    private boolean getResultExpression(String expression) {
        boolean result = false;
        if ("".equals(expression)) {
            result = true;
        } else {
            String operands = expression.replace('(', ' ');
            operands = operands.replace(')', ' ');
            operands = operands.replace('&', ' ');
            operands = operands.replace('|', ' ');
            operands = operands.replace('!', ' ');
            StringTokenizer token = new StringTokenizer(operands);
            HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
            while (token.hasMoreElements()) {
                Object value;
                String fieldName = (String)token.nextElement();
                if (variables.containsKey(fieldName)) continue;
                Field field = Connector.getField(this.getClass(), fieldName);
                Type type = field.getGenericType();
                boolean set = false;
                set = type.toString().equals("boolean") || type.toString().equals("class java.lang.Boolean") ? ((value = this.getFieldValue(field)) == null ? false : (Boolean)value) : this.isFieldSet(fieldName);
                variables.put(fieldName, set);
            }
            try {
                result = new ExpressionEvaluator(expression).evaluate(variables);
            }
            catch (Exception e) {
                LOG.severe(e.getMessage());
            }
        }
        return result;
    }

    private Object getFieldValue(Field field) {
        Object value = null;
        field.setAccessible(true);
        try {
            value = field.get(this);
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public final boolean containsErrors() {
        return !this.validate().isEmpty();
    }

    @Override
    public void execute(APIAccessor accessor, ActivityInstance activityInstance) throws Exception {
        this.execute();
    }

    public final List<Setter> getSetters() {
        ConnectorDescriptor descriptor = ConnectorDescriptorAPI.load(this.getClass());
        if (descriptor != null) {
            return descriptor.getInputs();
        }
        Method[] methods = this.getAllSetters();
        if (methods == null) {
            return null;
        }
        ArrayList<Setter> setters = new ArrayList<Setter>();
        for (Method method : methods) {
            String methodName = method.getName();
            setters.add(new Setter(methodName, null, null, method.getParameterTypes()));
        }
        return setters;
    }

    public final List<Getter> getGetters() {
        ConnectorDescriptor descriptor = ConnectorDescriptorAPI.load(this.getClass());
        if (descriptor != null) {
            return descriptor.getOutputs();
        }
        Method[] methods = this.getAllGetters();
        if (methods == null) {
            return null;
        }
        ArrayList<Getter> getters = new ArrayList<Getter>();
        for (Method method : methods) {
            String methodName = method.getName();
            getters.add(new Getter(Connector.getFieldName(methodName)));
        }
        return getters;
    }

    protected <K, V> Map<K, V> bonitaListToMap(List<List<Object>> array, Class<K> key, Class<V> value) {
        HashMap<K, V> map = null;
        if (array != null && array.size() > 0) {
            map = new HashMap<K, V>();
            for (List<Object> list : array) {
                map.put(key.cast(list.get(0)), value.cast(list.get(1)));
            }
        }
        return map;
    }

    protected <K, V> Map<K, Object[]> bonitaListToArrayMap(List<List<Object>> array, Class<K> key, Class<V> value) {
        HashMap<K, Object[]> map = null;
        if (array != null && array.size() > 0) {
            map = new HashMap<K, Object[]>();
            for (List<Object> list : array) {
                map.put(key.cast(list.get(0)), new Object[]{value.cast(list.get(1))});
            }
        }
        return map;
    }

    public static Method getMethod(Class<?> connectorClass, String methodName, Class<?>[] paramTypes) {
        try {
            return connectorClass.getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            if (paramTypes != null) {
                Method[] methods;
                for (Method method : methods = connectorClass.getMethods()) {
                    if (!methodName.equals(method.getName())) continue;
                    Class<?>[] types = method.getParameterTypes();
                    boolean check = true;
                    for (int i = 0; i < types.length; ++i) {
                        if (types[i].isAssignableFrom(paramTypes[i]) || paramTypes[i].isAssignableFrom(types[i]) || Connector.isWrapped(types[i], paramTypes[i])) continue;
                        check = false;
                        break;
                    }
                    if (!check) continue;
                    return method;
                }
            }
            return null;
        }
    }

    private static boolean isWrapped(Class<?> a, Class<?> b) {
        return a.equals(Byte.TYPE) && b.equals(Byte.class) || a.equals(Short.TYPE) && b.equals(Short.class) || a.equals(Integer.TYPE) && b.equals(Integer.class) || a.equals(Long.TYPE) && b.equals(Long.class) || a.equals(Float.TYPE) && b.equals(Float.class) || a.equals(Double.TYPE) && b.equals(Double.class) || a.equals(Character.TYPE) && b.equals(Character.class) || a.equals(Boolean.TYPE) && b.equals(Boolean.class);
    }

    private static boolean isAGetterMethod(Method m) {
        String methodName = m.getName();
        return (methodName.startsWith("get") || methodName.startsWith("is")) && m.getReturnType() != null;
    }

    private static boolean isASetterMethod(Method m) {
        String methodName = m.getName();
        return methodName.startsWith("set") && m.getParameterTypes() != null;
    }

    private Method[] getAllSetters() {
        Method[] methods;
        ArrayList<Method> setters = new ArrayList<Method>();
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            if (!Connector.isASetterMethod(method)) continue;
            setters.add(method);
        }
        return setters.toArray(new Method[0]);
    }

    private Method[] getAllGetters() {
        Method[] methods;
        ArrayList<Method> getters = new ArrayList<Method>();
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            if (!Connector.isAGetterMethod(method)) continue;
            getters.add(method);
        }
        return getters.toArray(new Method[0]);
    }

    public static Type getGetterReturnType(Class<? extends Connector> classConnector, String outputName) {
        try {
            String getterName = Connector.getGetterName(outputName);
            Method m = classConnector.getMethod(getterName, new Class[0]);
            return m.getGenericReturnType();
        }
        catch (Exception e) {
            return null;
        }
    }
}

