/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.connector.core;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.ow2.bonita.connector.core.Connector;
import org.ow2.bonita.connector.core.ConnectorAPI;
import org.ow2.bonita.connector.core.ConnectorDescriptorAPI;
import org.ow2.bonita.connector.core.ConnectorError;
import org.ow2.bonita.connector.core.ConnectorException;
import org.ow2.bonita.connector.core.desc.Category;
import org.ow2.bonita.connector.core.desc.Component;
import org.ow2.bonita.connector.core.desc.ConnectorDescriptor;
import org.ow2.bonita.connector.core.desc.Getter;
import org.ow2.bonita.connector.core.desc.Page;
import org.ow2.bonita.connector.core.desc.Setter;
import org.ow2.bonita.connector.core.desc.Text;

public class ConnectorDescription {
    private static final String LONELY_PAGE_ID = "lonely";
    private Class<? extends Connector> classConnector;
    private Locale currentLocale;
    private ConnectorDescriptor descriptor;
    private ResourceBundle bundle;

    public ConnectorDescription(Class<? extends Connector> classConnector) throws ConnectorException {
        this(classConnector, Locale.getDefault());
    }

    public ConnectorDescription(Class<? extends Connector> classConnector, Locale locale) throws ConnectorException {
        if (classConnector == null) {
            throw new IllegalArgumentException("The connector class cannot be null");
        }
        List<ConnectorError> errors = Connector.validateConnector(classConnector);
        if (!errors.isEmpty()) {
            throw new ConnectorException("The connector " + classConnector.getSimpleName() + " contains several errors!", classConnector.getName(), classConnector.getName(), errors);
        }
        this.classConnector = classConnector;
        this.currentLocale = locale;
        this.descriptor = ConnectorDescriptorAPI.load(classConnector);
    }

    public void setLocale(Locale locale) {
        this.currentLocale = locale;
    }

    public String getId() {
        String id = null;
        if (this.descriptor != null) {
            id = this.descriptor.getConnectorId();
        }
        if (id == null) {
            id = this.classConnector.getSimpleName();
        }
        return id;
    }

    public String getConnectorLabel() {
        String connector = this.getResourceBundleValue("ConnectorId");
        if (connector == null) {
            return this.getId();
        }
        return connector;
    }

    public String getConnectorVersion() {
        if (this.descriptor != null) {
            return this.descriptor.getVersion();
        }
        return "1.0";
    }

    public String getDescription() {
        return this.getResourceBundleValue("Description");
    }

    public String getCategoryName(String categoryId) {
        return this.getResourceBundleValue(categoryId);
    }

    public List<String> getPages() {
        ArrayList<String> pagesId = new ArrayList<String>();
        if (this.descriptor == null) {
            pagesId.add(LONELY_PAGE_ID);
        } else {
            List<Page> pages = this.descriptor.getPages();
            if (pages != null) {
                for (Page page : pages) {
                    pagesId.add(page.getPageId());
                }
            }
        }
        return pagesId;
    }

    public String getPageName(String pageId) {
        return this.getResourceBundleValue(pageId);
    }

    public String getPageDescription(String pageId) {
        return this.getResourceBundleValue(pageId + ".description");
    }

    public List<Component> getAllInputs() {
        ArrayList<Component> components;
        block5: {
            block4: {
                components = new ArrayList<Component>();
                if (this.descriptor == null) break block4;
                List<Page> pages = this.descriptor.getPages();
                if (pages == null) break block5;
                for (Page page : pages) {
                    components.addAll(page.getWidgets());
                }
                break block5;
            }
            try {
                Connector connector = this.classConnector.newInstance();
                List<Setter> setters = connector.getSetters();
                for (int i = 0; i < setters.size(); ++i) {
                    Setter setter = setters.get(i);
                    StringBuilder builder = new StringBuilder(setter.getSetterName());
                    builder.append(i);
                    Text text = new Text(builder.toString(), setter, 30, 60);
                    components.add(text);
                }
            }
            catch (Exception e) {
                return components;
            }
        }
        return components;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<String> getOutputNames() {
        ArrayList<String> ids = new ArrayList<String>();
        if (this.descriptor != null) {
            List<Getter> getters = this.descriptor.getOutputs();
            if (getters == null) return ids;
            for (Getter getter : getters) {
                ids.add(getter.getName());
            }
            return ids;
        } else {
            try {
                Connector connector = this.classConnector.newInstance();
                List<Getter> getters = connector.getGetters();
                if (getters == null) return ids;
                for (Getter getter : getters) {
                    ids.add(getter.getName());
                }
                return ids;
            }
            catch (Exception e) {
                return ids;
            }
        }
    }

    public Type getOutputType(String outputName) {
        return Connector.getGetterReturnType(this.classConnector, outputName);
    }

    private Page getPage(String pageId) {
        if (this.descriptor != null) {
            List<Page> pages = this.descriptor.getPages();
            for (Page page : pages) {
                if (!pageId.equals(page.getPageId())) continue;
                return page;
            }
        }
        return null;
    }

    public List<Component> getAllPageInputs(String pageId) {
        if (pageId.equals(LONELY_PAGE_ID)) {
            return this.getAllInputs();
        }
        Page page = this.getPage(pageId);
        if (page == null) {
            throw new IllegalArgumentException(pageId + " does not refer to a Connector page Id");
        }
        return page.getWidgets();
    }

    public String getInputLabel(String labelId) {
        String label = this.getResourceBundleValue(labelId + ".label");
        if (label == null) {
            return labelId;
        }
        return label;
    }

    public String getInputDescription(String labelId) {
        String label = this.getResourceBundleValue(labelId + ".description");
        if (label == null) {
            return labelId;
        }
        return label;
    }

    public InputStream getIcon() {
        String icon;
        InputStream is = null;
        if (this.descriptor != null && (icon = this.descriptor.getIcon()) != null && !"".equals(icon.trim())) {
            is = this.classConnector.getResourceAsStream(icon);
        }
        return is;
    }

    public String getIconPath() {
        String path = null;
        if (this.descriptor != null) {
            path = this.descriptor.getIcon();
        }
        return path;
    }

    private ResourceBundle getResourceBundle() {
        if (this.bundle != null) {
            return this.bundle;
        }
        String language = this.classConnector.getName();
        try {
            return ResourceBundle.getBundle(language, this.currentLocale, this.classConnector.getClassLoader());
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    private String getResourceBundleValue(String key) {
        ResourceBundle messages = this.getResourceBundle();
        if (messages == null) {
            return null;
        }
        try {
            return messages.getString(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class<? extends Connector> getConnectorClass() {
        return this.classConnector;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object != null && object instanceof ConnectorDescription) {
            ConnectorDescription description = (ConnectorDescription)object;
            if (this.getId().equals(description.getId())) {
                equals = true;
            }
        }
        return equals;
    }

    public List<Category> getCategories() {
        List<Category> categories;
        if (this.descriptor != null && (categories = this.descriptor.getCategories()) != null) {
            return categories;
        }
        categories = new ArrayList<Category>();
        categories.add(ConnectorAPI.other);
        return categories;
    }

    public List<Setter> getInputs() {
        ArrayList<Setter> setters = new ArrayList<Setter>();
        if (this.descriptor != null) {
            setters.addAll(this.descriptor.getInputs());
        }
        return setters;
    }

    public List<Getter> getOutputs() {
        ArrayList<Getter> getters = new ArrayList<Getter>();
        if (this.descriptor != null) {
            getters.addAll(this.descriptor.getOutputs());
        }
        return getters;
    }
}

