/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.EnvTool;

public class CatchingSignalEvent
extends AbstractActivity {
    private static final long serialVersionUID = 1163820971844205953L;

    protected CatchingSignalEvent() {
    }

    public CatchingSignalEvent(String eventName) {
        super(eventName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalActivityDefinition node = execution.getNode();
        Set<TransitionDefinition> outgoingTransitions = node.getOutgoingTransitions();
        Set<TransitionDefinition> incomingTransitions = node.getIncomingTransitions();
        boolean finishTask = true;
        if (!outgoingTransitions.isEmpty() && !incomingTransitions.isEmpty()) {
            this.catchEvent(execution);
            finishTask = false;
        }
        return finishTask;
    }

    private void catchEvent(Execution execution) {
        InternalActivityDefinition activity = execution.getNode();
        InternalProcessInstance instance = execution.getInstance();
        String processName = execution.getProcessDefinition().getName();
        String eventName = activity.getTimerCondition();
        String executionEventUUID = execution.getEventUUID();
        if (executionEventUUID == null) {
            executionEventUUID = "signal-" + UUID.randomUUID().toString();
        }
        IncomingEventInstance signalEventInstance = new IncomingEventInstance(eventName, null, instance.getUUID(), activity.getUUID(), null, processName, activity.getName(), executionEventUUID, "event.intermediate.signal", -1L, true);
        execution.setEventUUID(executionEventUUID);
        EventService eventService = EnvTool.getEventService();
        eventService.subscribe(signalEventInstance);
        execution.lock("Intermediate signal event " + executionEventUUID);
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> signalParameters) {
        if ("event.intermediate.signal".equals(signal)) {
            super.signal(execution, "bodyFinished", null);
        } else {
            super.signal(execution, signal, signalParameters);
        }
    }
}

