/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ActivityUtil;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalActivityInstance;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ProcessUtil;

public class ThrowingErrorEvent
extends AbstractActivity {
    private static final long serialVersionUID = -7250991226062578318L;

    protected ThrowingErrorEvent() {
    }

    public ThrowingErrorEvent(String eventName) {
        super(eventName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return true;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalProcessDefinition process = execution.getProcessDefinition();
        ActivityDefinition targetActivityDefinition = null;
        ActivityInstanceUUID targetActivityUUID = null;
        InternalActivityDefinition activity = execution.getNode();
        String throwingErrorCode = activity.getTimerCondition();
        ActivityDefinition eventSubProcessActivity = ActivityUtil.getMatchingErrorEvenSubProcessActivity(execution, throwingErrorCode);
        if (eventSubProcessActivity != null) {
            targetActivityDefinition = eventSubProcessActivity;
        } else {
            InternalProcessInstance instance = execution.getInstance();
            ActivityInstanceUUID parentActivityUUID = null;
            if (LightProcessDefinition.ProcessType.EVENT_SUB_PROCESS.equals((Object)process.getType())) {
                InternalProcessInstance rootEventSubProcess = EnvTool.getJournalQueriers().getProcessInstance(instance.getParentInstanceUUID());
                parentActivityUUID = rootEventSubProcess.getParentActivityUUID();
            } else {
                parentActivityUUID = instance.getParentActivityUUID();
            }
            if (parentActivityUUID != null) {
                InternalActivityInstance parentActivity = EnvTool.getJournalQueriers().getActivityInstance(parentActivityUUID);
                targetActivityDefinition = EnvTool.getJournalQueriers().getActivity(parentActivity.getActivityDefinitionUUID());
                targetActivityUUID = parentActivityUUID;
            }
        }
        Recorder recorder = EnvTool.getRecorder();
        InternalProcessInstance instance = execution.getInstance();
        if (targetActivityDefinition != null) {
            String errorCode = activity.getTimerCondition();
            String eventName = ActivityUtil.getErrorEventName(targetActivityDefinition, errorCode);
            String targetActivityName = targetActivityDefinition.getName();
            InternalProcessDefinition targetProcess = EnvTool.getJournalQueriers().getProcess(targetActivityDefinition.getProcessDefinitionUUID());
            String targetProcessName = targetProcess.getName();
            ProcessInstanceUUID targetInstanceUUID = null;
            if (targetActivityUUID != null) {
                InternalActivityInstance targetActivity = EnvTool.getJournalQueriers().getActivityInstance(targetActivityUUID);
                targetInstanceUUID = targetActivity.getProcessInstanceUUID();
            }
            OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, targetProcessName, targetActivityName, null, targetInstanceUUID, targetActivityUUID, -1L);
            EnvTool.getEventService().fire(outgoing);
            execution.abort();
            recorder.recordInstanceAborted(instance.getUUID(), EnvTool.getUserId());
        } else {
            execution.abort();
            recorder.recordInstanceAborted(instance.getUUID(), EnvTool.getUserId());
            ProcessUtil.removeInternalInstanceEvents(instance.getUUID());
            instance.finish();
        }
        return false;
    }
}

