/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.definition.activity;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.ow2.bonita.definition.activity.AbstractActivity;
import org.ow2.bonita.definition.activity.ConnectorExecutor;
import org.ow2.bonita.env.Authentication;
import org.ow2.bonita.facade.def.InternalActivityDefinition;
import org.ow2.bonita.facade.def.element.HookDefinition;
import org.ow2.bonita.facade.def.majorElement.TransitionDefinition;
import org.ow2.bonita.facade.runtime.impl.InternalProcessInstance;
import org.ow2.bonita.facade.uuid.ActivityInstanceUUID;
import org.ow2.bonita.facade.uuid.ProcessInstanceUUID;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.runtime.model.Execution;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.ProcessUtil;

public class Timer
extends AbstractActivity {
    private static final long serialVersionUID = 3180203041449396046L;
    protected static final Logger LOG = Logger.getLogger(Timer.class.getName());
    public static final String TIMER_SIGNAL = "end_of_timer";

    protected Timer() {
    }

    public Timer(String activityName) {
        super(activityName);
    }

    @Override
    protected boolean bodyStartAutomatically() {
        return false;
    }

    @Override
    protected boolean executeBusinessLogic(Execution execution) {
        InternalActivityDefinition node = execution.getNode();
        Set<TransitionDefinition> incomingTransitions = node.getIncomingTransitions();
        if (incomingTransitions.isEmpty()) {
            this.signal(execution, TIMER_SIGNAL, null);
        } else {
            long enableTime;
            String condition = execution.getNode().getTimerCondition();
            ActivityInstanceUUID activityUUID = execution.getActivityInstanceUUID();
            try {
                enableTime = ProcessUtil.getTimerDate(condition, activityUUID).getTime();
            }
            catch (GroovyException e) {
                StringBuilder stb = new StringBuilder("Error while evaluating timer's condition: '");
                stb.append(condition);
                stb.append("'.");
                throw new BonitaRuntimeException(stb.toString(), e);
            }
            String executionEventUUID = execution.getEventUUID();
            if (executionEventUUID == null) {
                executionEventUUID = "timer-" + UUID.randomUUID().toString();
            }
            String eventName = "**bonita_timer**-" + activityUUID;
            String processName = execution.getProcessDefinition().getName();
            String activityName = node.getName();
            InternalProcessInstance instance = execution.getInstance();
            ProcessInstanceUUID instanceUUID = instance.getProcessInstanceUUID();
            IncomingEventInstance incoming = new IncomingEventInstance(eventName, null, instanceUUID, node.getUUID(), activityUUID, processName, activityName, executionEventUUID, TIMER_SIGNAL, enableTime, true);
            OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, processName, activityName, null, instanceUUID, activityUUID, -1L);
            execution.setEventUUID(executionEventUUID);
            EventService eventService = EnvTool.getEventService();
            eventService.subscribe(incoming);
            eventService.fire(outgoing);
            execution.lock("Timer event " + executionEventUUID);
        }
        return false;
    }

    @Override
    public void signal(Execution execution, String signal, Map<String, Object> signalParameters) {
        if (TIMER_SIGNAL.equals(signal)) {
            Authentication.setUserId("SYSTEM");
            ConnectorExecutor.executeConnectors(execution.getNode(), execution, HookDefinition.Event.onTimer);
            super.signal(execution, "bodyFinished", null);
        } else {
            super.signal(execution, signal, signalParameters);
        }
    }
}

