/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.deployment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.deployment.DeploymentRuntimeException;
import org.ow2.bonita.facade.def.InternalProcessDefinition;
import org.ow2.bonita.facade.def.element.AttachmentDefinition;
import org.ow2.bonita.facade.def.element.BusinessArchive;
import org.ow2.bonita.facade.def.element.IncomingEventDefinition;
import org.ow2.bonita.facade.def.majorElement.ActivityDefinition;
import org.ow2.bonita.facade.def.majorElement.ProcessDefinition;
import org.ow2.bonita.facade.def.majorElement.impl.ProcessDefinitionImpl;
import org.ow2.bonita.facade.exception.DeploymentException;
import org.ow2.bonita.facade.runtime.Category;
import org.ow2.bonita.facade.runtime.impl.CategoryImpl;
import org.ow2.bonita.facade.uuid.ProcessDefinitionUUID;
import org.ow2.bonita.light.LightProcessDefinition;
import org.ow2.bonita.runtime.event.IncomingEventInstance;
import org.ow2.bonita.runtime.event.OutgoingEventInstance;
import org.ow2.bonita.services.DocumentationManager;
import org.ow2.bonita.services.EventService;
import org.ow2.bonita.services.LargeDataRepository;
import org.ow2.bonita.services.Querier;
import org.ow2.bonita.services.Recorder;
import org.ow2.bonita.util.ArchiveTool;
import org.ow2.bonita.util.BonitaRuntimeException;
import org.ow2.bonita.util.EnvTool;
import org.ow2.bonita.util.ExceptionManager;
import org.ow2.bonita.util.GroovyException;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.ProcessUtil;

public final class Deployer {
    private static final Logger LOG = Logger.getLogger(Deployer.class.getName());
    public static final String START_INSTANCE_SIGNAL = "start_event";

    private Deployer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessDefinition deploy(BusinessArchive businessArchive) throws DeploymentException {
        Recorder recorder = EnvTool.getRecorder();
        ProcessDefinitionUUID processUUID = businessArchive.getProcessUUID();
        if (processUUID == null) {
            throw new DeploymentException("The given businessArchive does not contain any process.");
        }
        LargeDataRepository ldr = EnvTool.getLargeDataRepository();
        for (Map.Entry<String, byte[]> resource : businessArchive.getResources().entrySet()) {
            ldr.storeData(Misc.getBusinessArchiveCategories(processUUID), resource.getKey(), (Serializable)resource.getValue(), true);
        }
        boolean removeDeps = true;
        try {
            ProcessDefinition process = null;
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader processClassloader = EnvTool.getClassDataLoader().getProcessClassLoader(processUUID);
                Thread.currentThread().setContextClassLoader(processClassloader);
                process = businessArchive.getProcessDefinition();
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            if (process == null) {
                throw new DeploymentRuntimeException("The given bar archive does not contain any process file");
            }
            String lastProcessVersion = EnvTool.getAllQueriers().getLastProcessVersion(process.getName());
            if (lastProcessVersion != null && lastProcessVersion.compareTo(process.getVersion()) >= 0) {
                if (lastProcessVersion.equals(process.getVersion())) {
                    removeDeps = false;
                }
                String message = ExceptionManager.getInstance().getFullMessage("bd_D_3", process.getName(), lastProcessVersion, process.getVersion(), lastProcessVersion);
                throw new DeploymentRuntimeException(message);
            }
            if (process.getClassDependencies() != null) {
                for (String className : process.getClassDependencies()) {
                    try {
                        EnvTool.getClassDataLoader().getClass(process.getUUID(), className);
                    }
                    catch (ClassNotFoundException e) {
                        String message = ExceptionManager.getInstance().getFullMessage("bd_D_7", process.getName(), className);
                        throw new DeploymentRuntimeException(message);
                    }
                }
            }
            DocumentationManager manager = EnvTool.getDocumentationManager();
            for (AttachmentDefinition attachment : process.getAttachments().values()) {
                if (attachment.getFilePath() != null) {
                    byte[] content = businessArchive.getResource(attachment.getFilePath());
                    try {
                        manager.createDocument(attachment.getName(), attachment.getProcessDefinitionUUID(), attachment.getFileName(), "application/octet-stream", content);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BonitaRuntimeException(e);
                    }
                }
                try {
                    manager.createDocument(attachment.getName(), attachment.getProcessDefinitionUUID());
                }
                catch (Exception e) {
                    throw new BonitaRuntimeException(e);
                }
            }
            InternalProcessDefinition internalProcess = null;
            try {
                Thread.currentThread().setContextClassLoader(EnvTool.getClassDataLoader().getProcessClassLoader(processUUID));
                internalProcess = new InternalProcessDefinition(process);
                if (internalProcess.getCategoryNames() != null && !internalProcess.getCategoryNames().isEmpty()) {
                    ArrayList<String> categoryNamesToBind = new ArrayList<String>(internalProcess.getCategoryNames());
                    Set<Category> persistedCategories = EnvTool.getJournalQueriers().getCategories(categoryNamesToBind);
                    if (persistedCategories.size() < categoryNamesToBind.size()) {
                        for (Category category : persistedCategories) {
                            categoryNamesToBind.remove(category.getName());
                        }
                        for (String name : categoryNamesToBind) {
                            recorder.recordNewCategory(new CategoryImpl(name));
                        }
                    }
                }
                internalProcess.setNbOfAttachments(process.getAttachments().size());
                recorder.recordProcessDeployed(internalProcess, EnvTool.getUserId());
                Deployer.addStartEvents(internalProcess);
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
            return new ProcessDefinitionImpl(internalProcess);
        }
        catch (RuntimeException re) {
            if (processUUID != null) {
                EnvTool.getClassDataLoader().removeProcessClassLoader(processUUID);
                if (removeDeps) {
                    ldr.deleteData(Misc.getBusinessArchiveCategories(processUUID));
                    ldr.deleteData(Misc.getAttachmentCategories(processUUID));
                }
            }
            throw re;
        }
    }

    public static boolean enableProcess(ProcessDefinitionUUID processUUID) {
        Misc.badStateIfNull(processUUID, "Impossible to enable a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.DISABLED)) {
            throw new DeploymentRuntimeException("Impossible to enable a process which is state is not disable");
        }
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessEnable(processDef);
        Deployer.addStartEvents(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" enable (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        return true;
    }

    public static boolean disableProcess(ProcessDefinitionUUID processUUID) {
        Misc.badStateIfNull(processUUID, "Impossible to disable a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.ENABLED)) {
            throw new DeploymentRuntimeException("Impossible to disable a process which is state is not enable");
        }
        Deployer.removeStartEvents(processDef);
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessDisable(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" disable (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        return true;
    }

    public static boolean archiveProcess(ProcessDefinitionUUID processUUID, String userId) {
        Misc.badStateIfNull(processUUID, "Impossible to archive a processUUID from a null uuid");
        Querier journal = EnvTool.getJournalQueriers();
        InternalProcessDefinition processDef = journal.getProcess(processUUID);
        if (processDef == null) {
            String message = ExceptionManager.getInstance().getFullMessage("bd_D_8", processUUID);
            throw new DeploymentRuntimeException(message);
        }
        if (!processDef.getState().equals((Object)ProcessDefinition.ProcessState.DISABLED)) {
            throw new DeploymentRuntimeException("Impossible to archive a process which its state is not disable");
        }
        HashSet<ProcessDefinitionUUID> definitionUUIDs = new HashSet<ProcessDefinitionUUID>();
        definitionUUIDs.add(processUUID);
        int numberOfProcessInstances = journal.getNumberOfProcessInstances(definitionUUIDs);
        if (numberOfProcessInstances != 0) {
            throw new DeploymentRuntimeException("Impossible to archive a process with " + numberOfProcessInstances + " running instance(s)");
        }
        Deployer.removeStartEvents(processDef);
        Recorder recorder = EnvTool.getRecorder();
        recorder.recordProcessArchive(processDef, userId);
        ArchiveTool.atomicArchive(processDef);
        if (LOG.isLoggable(Level.INFO)) {
            StringBuilder logMsg = new StringBuilder();
            logMsg.append("Process ").append(processDef.getName()).append(" archive (UUID: ").append(processDef.getUUID()).append(").");
            LOG.info(logMsg.toString());
        }
        EnvTool.getClassDataLoader().removeProcessClassLoader(processDef.getUUID());
        EnvTool.getUUIDService().archiveOrDeleteProcess(processUUID);
        return true;
    }

    private static void addStartEvents(ProcessDefinition processDef) throws DeploymentRuntimeException {
        if (LightProcessDefinition.ProcessType.PROCESS.equals((Object)processDef.getType())) {
            for (ActivityDefinition activity : processDef.getActivities()) {
                if (!activity.getIncomingTransitions().isEmpty()) continue;
                ActivityDefinition.Type activityType = activity.getType();
                if (activityType.equals((Object)ActivityDefinition.Type.ReceiveEvent)) {
                    IncomingEventDefinition event = activity.getIncomingEvent();
                    if (event == null) continue;
                    EventService eventService = EnvTool.getEventService();
                    IncomingEventInstance incomingEventInstance = new IncomingEventInstance(event.getName(), event.getExpression(), null, activity.getUUID(), null, processDef.getName(), activity.getName(), null, START_INSTANCE_SIGNAL, System.currentTimeMillis(), false);
                    incomingEventInstance.setPermanent(true);
                    eventService.subscribe(incomingEventInstance);
                    continue;
                }
                if (activityType.equals((Object)ActivityDefinition.Type.Timer)) {
                    EventService eventService = EnvTool.getEventService();
                    String eventName = "**bonita_timer**-" + activity.getUUID();
                    ProcessDefinitionUUID definitionUUID = activity.getProcessDefinitionUUID();
                    String condition = activity.getTimerCondition();
                    try {
                        OutgoingEventInstance outgoing = new OutgoingEventInstance(eventName, null, null, null, null, null, -1L);
                        eventService.fire(outgoing);
                        Date date = ProcessUtil.getTimerDate(condition, definitionUUID, System.currentTimeMillis());
                        IncomingEventInstance timerEventInstance = new IncomingEventInstance(eventName, condition, null, activity.getUUID(), null, processDef.getName(), activity.getName(), null, "event.start.timer", date.getTime(), false);
                        timerEventInstance.setPermanent(true);
                        eventService.subscribe(timerEventInstance);
                        continue;
                    }
                    catch (GroovyException e) {
                        throw new DeploymentRuntimeException(e.getMessage(), e.getCause());
                    }
                }
                if (!activityType.equals((Object)ActivityDefinition.Type.SignalEvent)) continue;
                String eventName = activity.getTimerCondition();
                IncomingEventInstance signalEventInstance = new IncomingEventInstance(eventName, null, null, activity.getUUID(), null, processDef.getName(), activity.getName(), null, "event.start.signal", -1L, false);
                signalEventInstance.setPermanent(true);
                EventService eventService = EnvTool.getEventService();
                eventService.subscribe(signalEventInstance);
            }
        }
    }

    public static void removeStartEvents(ProcessDefinition processDef) {
        for (ActivityDefinition activity : processDef.getActivities()) {
            EventService eventService;
            if (!activity.getIncomingTransitions().isEmpty()) continue;
            ActivityDefinition.Type activityType = activity.getType();
            IncomingEventDefinition event = activity.getIncomingEvent();
            if (event != null) {
                eventService = EnvTool.getEventService();
                eventService.removeSubscriptions(activity.getUUID());
                continue;
            }
            if (activityType.equals((Object)ActivityDefinition.Type.Timer)) {
                eventService = EnvTool.getEventService();
                String eventName = "**bonita_timer**-" + activity.getUUID();
                eventService.removeSubscriptions(activity.getUUID());
                Set<OutgoingEventInstance> outgoingTimerEvents = eventService.getOutgoingEvents(eventName, null, null, null);
                if (outgoingTimerEvents.isEmpty()) continue;
                eventService.removeEvent(outgoingTimerEvents.iterator().next());
                continue;
            }
            if (!activityType.equals((Object)ActivityDefinition.Type.SignalEvent)) continue;
            eventService = EnvTool.getEventService();
            eventService.removeSubscriptions(activity.getUUID());
        }
    }
}

