/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.bonita.env;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ow2.bonita.env.Context;
import org.ow2.bonita.env.Environment;
import org.ow2.bonita.env.EnvironmentFactory;
import org.ow2.bonita.env.PvmEnvironment;
import org.ow2.bonita.env.PvmEnvironmentFactoryParser;
import org.ow2.bonita.env.WireContext;
import org.ow2.bonita.env.WireDefinition;
import org.ow2.bonita.util.Misc;
import org.ow2.bonita.util.stream.FileStreamSource;
import org.ow2.bonita.util.stream.InputStreamSource;
import org.ow2.bonita.util.stream.ResourceStreamSource;
import org.ow2.bonita.util.stream.StreamSource;
import org.ow2.bonita.util.stream.StringStreamSource;
import org.ow2.bonita.util.stream.UrlStreamSource;
import org.ow2.bonita.util.xml.Parse;

public class PvmEnvironmentFactory
extends EnvironmentFactory
implements Context {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(PvmEnvironmentFactory.class.getName());
    protected static PvmEnvironmentFactoryParser pvmEnvironmentFactoryParser = new PvmEnvironmentFactoryParser();
    protected WireContext environmentFactoryCtxWireContext = null;
    protected WireDefinition environmentCtxWireDefinition = null;

    public PvmEnvironmentFactory() {
    }

    public PvmEnvironmentFactory(String resource) {
        this(resource, null);
    }

    public PvmEnvironmentFactory(String resource, ClassLoader classLoader) {
        this(new ResourceStreamSource(resource, classLoader));
    }

    public PvmEnvironmentFactory(File file) {
        this(new FileStreamSource(file));
    }

    public PvmEnvironmentFactory(URL url) {
        this(new UrlStreamSource(url));
    }

    public PvmEnvironmentFactory(InputStream inputStream) {
        this(new InputStreamSource(inputStream));
    }

    public static PvmEnvironmentFactory parseXmlString(String xmlString) {
        return new PvmEnvironmentFactory(new StringStreamSource(xmlString));
    }

    PvmEnvironmentFactory(StreamSource streamSource) {
        Parse parse = PvmEnvironmentFactoryParser.getInstance().createParse().setDocumentObject(this).setStreamSource(streamSource).execute();
        Misc.showProblems(parse.getProblems(), "pvm environment configuration " + streamSource);
    }

    @Override
    public Environment openEnvironment() {
        ClassLoader classLoader;
        PvmEnvironment environment = new PvmEnvironment(this);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("opening " + environment);
        }
        if ((classLoader = this.environmentFactoryCtxWireContext.getClassLoader()) != null) {
            environment.setClassLoader(classLoader);
        }
        environment.addContext(this.environmentFactoryCtxWireContext);
        WireContext environmentContext = new WireContext(this.environmentCtxWireDefinition, "environment", environment, true);
        environment.addContext(environmentContext);
        try {
            environmentContext.create();
        }
        catch (RuntimeException e) {
            Environment.popEnvironment();
            throw e;
        }
        return environment;
    }

    @Override
    public void close() {
        this.environmentFactoryCtxWireContext.fire("close", null);
    }

    @Override
    public Object get(String key) {
        return this.environmentFactoryCtxWireContext.get(key);
    }

    @Override
    public <T> T get(Class<T> type) {
        return this.environmentFactoryCtxWireContext.get(type);
    }

    @Override
    public String getName() {
        return this.environmentFactoryCtxWireContext.getName();
    }

    @Override
    public boolean has(String key) {
        return this.environmentFactoryCtxWireContext.has(key);
    }

    @Override
    public Set<String> keys() {
        return this.environmentFactoryCtxWireContext.keys();
    }

    @Override
    public Object set(String key, Object value) {
        return this.environmentFactoryCtxWireContext.set(key, value);
    }

    public void setEnvironmentCtxWireDefinition(WireDefinition blockWireDefinition) {
        this.environmentCtxWireDefinition = blockWireDefinition;
    }

    public WireContext getEnvironmentFactoryCtxWireContext() {
        return this.environmentFactoryCtxWireContext;
    }

    public void setEnvironmentFactoryCtxWireContext(WireContext applicationWireContext) {
        this.environmentFactoryCtxWireContext = applicationWireContext;
    }

    public WireDefinition getEnvironmentCtxWireDefinition() {
        return this.environmentCtxWireDefinition;
    }
}

